package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.UrlType
import scala.jdk.CollectionConverters._
final case class MessagingSessionEndpoint(url: Option[UrlType] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.MessagingSessionEndpoint = {
    import MessagingSessionEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.MessagingSessionEndpoint
      .builder()
      .optionallyWith(
        url.map(value => UrlType.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.MessagingSessionEndpoint.ReadOnly =
    zio.aws.chimesdkmessaging.model.MessagingSessionEndpoint
      .wrap(buildAwsValue())
}
object MessagingSessionEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.MessagingSessionEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.MessagingSessionEndpoint =
      zio.aws.chimesdkmessaging.model
        .MessagingSessionEndpoint(url.map(value => value))
    def url: Option[UrlType]
    def getUrl: ZIO[Any, AwsError, UrlType] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.MessagingSessionEndpoint
  ) extends zio.aws.chimesdkmessaging.model.MessagingSessionEndpoint.ReadOnly {
    override val url: Option[UrlType] = scala
      .Option(impl.url())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.UrlType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.MessagingSessionEndpoint
  ): zio.aws.chimesdkmessaging.model.MessagingSessionEndpoint.ReadOnly =
    new Wrapper(impl)
}
