package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{NextToken, ChimeArn}
import scala.jdk.CollectionConverters._
final case class ListChannelMembershipsResponse(
    channelArn: Option[ChimeArn] = None,
    channelMemberships: Option[
      Iterable[zio.aws.chimesdkmessaging.model.ChannelMembershipSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsResponse = {
    import ListChannelMembershipsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        channelMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelMemberships)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse
      .wrap(buildAwsValue())
}
object ListChannelMembershipsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse =
      zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse(
        channelArn.map(value => value),
        channelMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def channelArn: Option[ChimeArn]
    def channelMemberships: Option[
      List[zio.aws.chimesdkmessaging.model.ChannelMembershipSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getChannelMemberships: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.ChannelMembershipSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channelMemberships", channelMemberships)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsResponse
  ) extends zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.ReadOnly {
    override val channelArn: Option[ChimeArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val channelMemberships: Option[
      List[zio.aws.chimesdkmessaging.model.ChannelMembershipSummary.ReadOnly]
    ] = scala
      .Option(impl.channelMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmessaging.model.ChannelMembershipSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsResponse
  ): zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.ReadOnly =
    new Wrapper(impl)
}
