package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListChannelMembershipsForAppInstanceUserResponse(
    channelMemberships: Option[Iterable[
      zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary
    ]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse = {
    import ListChannelMembershipsForAppInstanceUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse
      .builder()
      .optionallyWith(
        channelMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelMemberships)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse
      .wrap(buildAwsValue())
}
object ListChannelMembershipsForAppInstanceUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse =
      zio.aws.chimesdkmessaging.model
        .ListChannelMembershipsForAppInstanceUserResponse(
          channelMemberships.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def channelMemberships: Option[List[
      zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ]]
    def nextToken: Option[NextToken]
    def getChannelMemberships: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channelMemberships", channelMemberships)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse
  ) extends zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly {
    override val channelMemberships: Option[List[
      zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ]] = scala
      .Option(impl.channelMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse
  ): zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly =
    new Wrapper(impl)
}
