package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetChannelMessageResponse(
    channelMessage: Option[zio.aws.chimesdkmessaging.model.ChannelMessage] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMessageResponse = {
    import GetChannelMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMessageResponse
      .builder()
      .optionallyWith(channelMessage.map(value => value.buildAwsValue()))(
        _.channelMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.GetChannelMessageResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.GetChannelMessageResponse
      .wrap(buildAwsValue())
}
object GetChannelMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.GetChannelMessageResponse =
      zio.aws.chimesdkmessaging.model.GetChannelMessageResponse(
        channelMessage.map(value => value.asEditable)
      )
    def channelMessage
        : Option[zio.aws.chimesdkmessaging.model.ChannelMessage.ReadOnly]
    def getChannelMessage: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMessage.ReadOnly
    ] = AwsError.unwrapOptionField("channelMessage", channelMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMessageResponse
  ) extends zio.aws.chimesdkmessaging.model.GetChannelMessageResponse.ReadOnly {
    override val channelMessage
        : Option[zio.aws.chimesdkmessaging.model.ChannelMessage.ReadOnly] =
      scala
        .Option(impl.channelMessage())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelMessage.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMessageResponse
  ): zio.aws.chimesdkmessaging.model.GetChannelMessageResponse.ReadOnly =
    new Wrapper(impl)
}
