package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{NextToken, ChimeArn}
import scala.jdk.CollectionConverters._
final case class ListChannelModeratorsResponse(
    channelArn: Option[ChimeArn] = None,
    nextToken: Option[NextToken] = None,
    channelModerators: Option[
      Iterable[zio.aws.chimesdkmessaging.model.ChannelModeratorSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsResponse = {
    import ListChannelModeratorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        channelModerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelModerators)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse
      .wrap(buildAwsValue())
}
object ListChannelModeratorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse =
      zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse(
        channelArn.map(value => value),
        nextToken.map(value => value),
        channelModerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channelArn: Option[ChimeArn]
    def nextToken: Option[NextToken]
    def channelModerators: Option[
      List[zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly]
    ]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChannelModerators: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channelModerators", channelModerators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsResponse
  ) extends zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly {
    override val channelArn: Option[ChimeArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
    override val channelModerators: Option[
      List[zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly]
    ] = scala
      .Option(impl.channelModerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsResponse
  ): zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly =
    new Wrapper(impl)
}
