package zio.aws.chimesdkmessaging.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.{
  ChannelFlowExecutionOrder,
  NonEmptyResourceName
}
import scala.jdk.CollectionConverters._
final case class Processor(
    name: NonEmptyResourceName,
    configuration: zio.aws.chimesdkmessaging.model.ProcessorConfiguration,
    executionOrder: ChannelFlowExecutionOrder,
    fallbackAction: zio.aws.chimesdkmessaging.model.FallbackAction
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.Processor = {
    import Processor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.Processor
      .builder()
      .name(NonEmptyResourceName.unwrap(name): java.lang.String)
      .configuration(configuration.buildAwsValue())
      .executionOrder(ChannelFlowExecutionOrder.unwrap(executionOrder): Integer)
      .fallbackAction(fallbackAction.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.Processor.ReadOnly =
    zio.aws.chimesdkmessaging.model.Processor.wrap(buildAwsValue())
}
object Processor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.Processor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.Processor =
      zio.aws.chimesdkmessaging.model.Processor(
        name,
        configuration.asEditable,
        executionOrder,
        fallbackAction
      )
    def name: NonEmptyResourceName
    def configuration
        : zio.aws.chimesdkmessaging.model.ProcessorConfiguration.ReadOnly
    def executionOrder: ChannelFlowExecutionOrder
    def fallbackAction: zio.aws.chimesdkmessaging.model.FallbackAction
    def getName: ZIO[Any, Nothing, NonEmptyResourceName] = ZIO.succeed(name)
    def getConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmessaging.model.ProcessorConfiguration.ReadOnly
    ] = ZIO.succeed(configuration)
    def getExecutionOrder: ZIO[Any, Nothing, ChannelFlowExecutionOrder] =
      ZIO.succeed(executionOrder)
    def getFallbackAction
        : ZIO[Any, Nothing, zio.aws.chimesdkmessaging.model.FallbackAction] =
      ZIO.succeed(fallbackAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.Processor
  ) extends zio.aws.chimesdkmessaging.model.Processor.ReadOnly {
    override val name: NonEmptyResourceName =
      zio.aws.chimesdkmessaging.model.primitives
        .NonEmptyResourceName(impl.name())
    override val configuration
        : zio.aws.chimesdkmessaging.model.ProcessorConfiguration.ReadOnly =
      zio.aws.chimesdkmessaging.model.ProcessorConfiguration
        .wrap(impl.configuration())
    override val executionOrder: ChannelFlowExecutionOrder =
      zio.aws.chimesdkmessaging.model.primitives
        .ChannelFlowExecutionOrder(impl.executionOrder())
    override val fallbackAction
        : zio.aws.chimesdkmessaging.model.FallbackAction =
      zio.aws.chimesdkmessaging.model.FallbackAction.wrap(impl.fallbackAction())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.Processor
  ): zio.aws.chimesdkmessaging.model.Processor.ReadOnly = new Wrapper(impl)
}
