package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{MessageId, ChimeArn}
import scala.jdk.CollectionConverters._
final case class RedactChannelMessageResponse(
    channelArn: Option[ChimeArn] = None,
    messageId: Option[MessageId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.RedactChannelMessageResponse = {
    import RedactChannelMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.RedactChannelMessageResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse
      .wrap(buildAwsValue())
}
object RedactChannelMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.RedactChannelMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse =
      zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse(
        channelArn.map(value => value),
        messageId.map(value => value)
      )
    def channelArn: Option[ChimeArn]
    def messageId: Option[MessageId]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.RedactChannelMessageResponse
  ) extends zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse.ReadOnly {
    override val channelArn: Option[ChimeArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val messageId: Option[MessageId] = scala
      .Option(impl.messageId())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.MessageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.RedactChannelMessageResponse
  ): zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse.ReadOnly =
    new Wrapper(impl)
}
