package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.chimesdkmessaging.model.primitives.{
  Timestamp,
  Metadata,
  ChimeArn,
  NonEmptyResourceName
}
import scala.jdk.CollectionConverters._
final case class ChannelSummary(
    name: Option[NonEmptyResourceName] = None,
    channelArn: Option[ChimeArn] = None,
    mode: Option[zio.aws.chimesdkmessaging.model.ChannelMode] = None,
    privacy: Option[zio.aws.chimesdkmessaging.model.ChannelPrivacy] = None,
    metadata: Option[Metadata] = None,
    lastMessageTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelSummary = {
    import ChannelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelSummary
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(privacy.map(value => value.unwrap))(_.privacy)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(
        lastMessageTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastMessageTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelSummary.wrap(buildAwsValue())
}
object ChannelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelSummary =
      zio.aws.chimesdkmessaging.model.ChannelSummary(
        name.map(value => value),
        channelArn.map(value => value),
        mode.map(value => value),
        privacy.map(value => value),
        metadata.map(value => value),
        lastMessageTimestamp.map(value => value)
      )
    def name: Option[NonEmptyResourceName]
    def channelArn: Option[ChimeArn]
    def mode: Option[zio.aws.chimesdkmessaging.model.ChannelMode]
    def privacy: Option[zio.aws.chimesdkmessaging.model.ChannelPrivacy]
    def metadata: Option[Metadata]
    def lastMessageTimestamp: Option[Timestamp]
    def getName: ZIO[Any, AwsError, NonEmptyResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMode
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ChannelMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getPrivacy
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ChannelPrivacy] =
      AwsError.unwrapOptionField("privacy", privacy)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getLastMessageTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastMessageTimestamp", lastMessageTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelSummary
  ) extends zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly {
    override val name: Option[NonEmptyResourceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonEmptyResourceName(value)
      )
    override val channelArn: Option[ChimeArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val mode: Option[zio.aws.chimesdkmessaging.model.ChannelMode] =
      scala
        .Option(impl.mode())
        .map(value => zio.aws.chimesdkmessaging.model.ChannelMode.wrap(value))
    override val privacy
        : Option[zio.aws.chimesdkmessaging.model.ChannelPrivacy] = scala
      .Option(impl.privacy())
      .map(value => zio.aws.chimesdkmessaging.model.ChannelPrivacy.wrap(value))
    override val metadata: Option[Metadata] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
    override val lastMessageTimestamp: Option[Timestamp] = scala
      .Option(impl.lastMessageTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelSummary
  ): zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly = new Wrapper(impl)
}
