package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ChannelMembershipForAppInstanceUserSummary(
    channelSummary: Option[zio.aws.chimesdkmessaging.model.ChannelSummary] =
      None,
    appInstanceUserMembershipSummary: Option[
      zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary = {
    import ChannelMembershipForAppInstanceUserSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary
      .builder()
      .optionallyWith(channelSummary.map(value => value.buildAwsValue()))(
        _.channelSummary
      )
      .optionallyWith(
        appInstanceUserMembershipSummary.map(value => value.buildAwsValue())
      )(_.appInstanceUserMembershipSummary)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary
      .wrap(buildAwsValue())
}
object ChannelMembershipForAppInstanceUserSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary =
      zio.aws.chimesdkmessaging.model
        .ChannelMembershipForAppInstanceUserSummary(
          channelSummary.map(value => value.asEditable),
          appInstanceUserMembershipSummary.map(value => value.asEditable)
        )
    def channelSummary
        : Option[zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly]
    def appInstanceUserMembershipSummary: Option[
      zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary.ReadOnly
    ]
    def getChannelSummary: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly
    ] = AwsError.unwrapOptionField("channelSummary", channelSummary)
    def getAppInstanceUserMembershipSummary: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "appInstanceUserMembershipSummary",
      appInstanceUserMembershipSummary
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary
  ) extends zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly {
    override val channelSummary
        : Option[zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly] =
      scala
        .Option(impl.channelSummary())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelSummary.wrap(value)
        )
    override val appInstanceUserMembershipSummary: Option[
      zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary.ReadOnly
    ] = scala
      .Option(impl.appInstanceUserMembershipSummary())
      .map(value =>
        zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary
  ): zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly =
    new Wrapper(impl)
}
