package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class DeleteChannelModeratorRequest(
    channelArn: ChimeArn,
    channelModeratorArn: ChimeArn,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelModeratorRequest = {
    import DeleteChannelModeratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelModeratorRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .channelModeratorArn(
        ChimeArn.unwrap(channelModeratorArn): java.lang.String
      )
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DeleteChannelModeratorRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.DeleteChannelModeratorRequest
      .wrap(buildAwsValue())
}
object DeleteChannelModeratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelModeratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.DeleteChannelModeratorRequest =
      zio.aws.chimesdkmessaging.model.DeleteChannelModeratorRequest(
        channelArn,
        channelModeratorArn,
        chimeBearer
      )
    def channelArn: ChimeArn
    def channelModeratorArn: ChimeArn
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getChannelModeratorArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(channelModeratorArn)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelModeratorRequest
  ) extends zio.aws.chimesdkmessaging.model.DeleteChannelModeratorRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val channelModeratorArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives
        .ChimeArn(impl.channelModeratorArn())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelModeratorRequest
  ): zio.aws.chimesdkmessaging.model.DeleteChannelModeratorRequest.ReadOnly =
    new Wrapper(impl)
}
