package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.chimesdkmessaging.model.primitives.{
  MessageId,
  MessageAttributeName,
  ChimeArn,
  Timestamp,
  NonNullableBoolean,
  Content,
  Metadata
}
import scala.jdk.CollectionConverters._
final case class ChannelMessage(
    channelArn: Option[ChimeArn] = None,
    messageId: Option[MessageId] = None,
    content: Option[Content] = None,
    metadata: Option[Metadata] = None,
    `type`: Option[zio.aws.chimesdkmessaging.model.ChannelMessageType] = None,
    createdTimestamp: Option[Timestamp] = None,
    lastEditedTimestamp: Option[Timestamp] = None,
    lastUpdatedTimestamp: Option[Timestamp] = None,
    sender: Option[zio.aws.chimesdkmessaging.model.Identity] = None,
    redacted: Option[NonNullableBoolean] = None,
    persistence: Option[
      zio.aws.chimesdkmessaging.model.ChannelMessagePersistenceType
    ] = None,
    status: Option[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure
    ] = None,
    messageAttributes: Option[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessage = {
    import ChannelMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessage
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .optionallyWith(
        content.map(value => Content.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastEditedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastEditedTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .optionallyWith(sender.map(value => value.buildAwsValue()))(_.sender)
      .optionallyWith(
        redacted.map(value =>
          NonNullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.redacted)
      .optionallyWith(persistence.map(value => value.unwrap))(_.persistence)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        messageAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (MessageAttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.messageAttributes)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.ChannelMessage.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelMessage.wrap(buildAwsValue())
}
object ChannelMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelMessage =
      zio.aws.chimesdkmessaging.model.ChannelMessage(
        channelArn.map(value => value),
        messageId.map(value => value),
        content.map(value => value),
        metadata.map(value => value),
        `type`.map(value => value),
        createdTimestamp.map(value => value),
        lastEditedTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        sender.map(value => value.asEditable),
        redacted.map(value => value),
        persistence.map(value => value),
        status.map(value => value.asEditable),
        messageAttributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def channelArn: Option[ChimeArn]
    def messageId: Option[MessageId]
    def content: Option[Content]
    def metadata: Option[Metadata]
    def `type`: Option[zio.aws.chimesdkmessaging.model.ChannelMessageType]
    def createdTimestamp: Option[Timestamp]
    def lastEditedTimestamp: Option[Timestamp]
    def lastUpdatedTimestamp: Option[Timestamp]
    def sender: Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def redacted: Option[NonNullableBoolean]
    def persistence
        : Option[zio.aws.chimesdkmessaging.model.ChannelMessagePersistenceType]
    def status: Option[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ]
    def messageAttributes: Option[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getContent: ZIO[Any, AwsError, Content] =
      AwsError.unwrapOptionField("content", content)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMessageType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastEditedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastEditedTimestamp", lastEditedTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getSender: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("sender", sender)
    def getRedacted: ZIO[Any, AwsError, NonNullableBoolean] =
      AwsError.unwrapOptionField("redacted", redacted)
    def getPersistence: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMessagePersistenceType
    ] = AwsError.unwrapOptionField("persistence", persistence)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getMessageAttributes: ZIO[Any, AwsError, Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("messageAttributes", messageAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessage
  ) extends zio.aws.chimesdkmessaging.model.ChannelMessage.ReadOnly {
    override val channelArn: Option[ChimeArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val messageId: Option[MessageId] = scala
      .Option(impl.messageId())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.MessageId(value))
    override val content: Option[Content] = scala
      .Option(impl.content())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Content(value))
    override val metadata: Option[Metadata] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
    override val `type`
        : Option[zio.aws.chimesdkmessaging.model.ChannelMessageType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMessageType.wrap(value)
      )
    override val createdTimestamp: Option[Timestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val lastEditedTimestamp: Option[Timestamp] = scala
      .Option(impl.lastEditedTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val sender
        : Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] = scala
      .Option(impl.sender())
      .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
    override val redacted: Option[NonNullableBoolean] = scala
      .Option(impl.redacted())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonNullableBoolean(value)
      )
    override val persistence: Option[
      zio.aws.chimesdkmessaging.model.ChannelMessagePersistenceType
    ] = scala
      .Option(impl.persistence())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMessagePersistenceType
          .wrap(value)
      )
    override val status: Option[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure
          .wrap(value)
      )
    override val messageAttributes: Option[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]] = scala
      .Option(impl.messageAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.chimesdkmessaging.model.primitives.MessageAttributeName(
              key
            ) -> zio.aws.chimesdkmessaging.model.MessageAttributeValue
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessage
  ): zio.aws.chimesdkmessaging.model.ChannelMessage.ReadOnly = new Wrapper(impl)
}
