package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class PutChannelMembershipPreferencesRequest(
    channelArn: ChimeArn,
    memberArn: ChimeArn,
    chimeBearer: ChimeArn,
    preferences: zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest = {
    import PutChannelMembershipPreferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .memberArn(ChimeArn.unwrap(memberArn): java.lang.String)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .preferences(preferences.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest
      .wrap(buildAwsValue())
}
object PutChannelMembershipPreferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest =
      zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest(
        channelArn,
        memberArn,
        chimeBearer,
        preferences.asEditable
      )
    def channelArn: ChimeArn
    def memberArn: ChimeArn
    def chimeBearer: ChimeArn
    def preferences
        : zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.ReadOnly
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getMemberArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(memberArn)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
    def getPreferences: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.ReadOnly
    ] = ZIO.succeed(preferences)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest
  ) extends zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val memberArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.memberArn())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
    override val preferences
        : zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.ReadOnly =
      zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences
        .wrap(impl.preferences())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest
  ): zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest.ReadOnly =
    new Wrapper(impl)
}
