package zio.aws.chimesdkmessaging.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{
  NextToken,
  MaxResults,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class ListChannelMembershipsRequest(
    channelArn: ChimeArn,
    `type`: Option[zio.aws.chimesdkmessaging.model.ChannelMembershipType] =
      None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsRequest = {
    import ListChannelMembershipsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest
      .wrap(buildAwsValue())
}
object ListChannelMembershipsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest =
      zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest(
        channelArn,
        `type`.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        chimeBearer
      )
    def channelArn: ChimeArn
    def `type`: Option[zio.aws.chimesdkmessaging.model.ChannelMembershipType]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMembershipType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsRequest
  ) extends zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val `type`
        : Option[zio.aws.chimesdkmessaging.model.ChannelMembershipType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMembershipType.wrap(value)
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsRequest
  ): zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest.ReadOnly =
    new Wrapper(impl)
}
