package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ChannelModeratorSummary(
    moderator: Option[zio.aws.chimesdkmessaging.model.Identity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelModeratorSummary = {
    import ChannelModeratorSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelModeratorSummary
      .builder()
      .optionallyWith(moderator.map(value => value.buildAwsValue()))(
        _.moderator
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelModeratorSummary
      .wrap(buildAwsValue())
}
object ChannelModeratorSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelModeratorSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelModeratorSummary =
      zio.aws.chimesdkmessaging.model
        .ChannelModeratorSummary(moderator.map(value => value.asEditable))
    def moderator: Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def getModerator: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("moderator", moderator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelModeratorSummary
  ) extends zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly {
    override val moderator
        : Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] = scala
      .Option(impl.moderator())
      .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelModeratorSummary
  ): zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly =
    new Wrapper(impl)
}
