package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.chimesdkmessaging.model.primitives.{
  MessageId,
  MessageAttributeName,
  Timestamp,
  NonNullableBoolean,
  Content,
  Metadata
}
import scala.jdk.CollectionConverters._
final case class ChannelMessageSummary(
    messageId: Option[MessageId] = None,
    content: Option[Content] = None,
    metadata: Option[Metadata] = None,
    `type`: Option[zio.aws.chimesdkmessaging.model.ChannelMessageType] = None,
    createdTimestamp: Option[Timestamp] = None,
    lastUpdatedTimestamp: Option[Timestamp] = None,
    lastEditedTimestamp: Option[Timestamp] = None,
    sender: Option[zio.aws.chimesdkmessaging.model.Identity] = None,
    redacted: Option[NonNullableBoolean] = None,
    status: Option[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure
    ] = None,
    messageAttributes: Option[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageSummary = {
    import ChannelMessageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageSummary
      .builder()
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .optionallyWith(
        content.map(value => Content.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .optionallyWith(
        lastEditedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastEditedTimestamp)
      .optionallyWith(sender.map(value => value.buildAwsValue()))(_.sender)
      .optionallyWith(
        redacted.map(value =>
          NonNullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.redacted)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        messageAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (MessageAttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.messageAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelMessageSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelMessageSummary.wrap(buildAwsValue())
}
object ChannelMessageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelMessageSummary =
      zio.aws.chimesdkmessaging.model.ChannelMessageSummary(
        messageId.map(value => value),
        content.map(value => value),
        metadata.map(value => value),
        `type`.map(value => value),
        createdTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        lastEditedTimestamp.map(value => value),
        sender.map(value => value.asEditable),
        redacted.map(value => value),
        status.map(value => value.asEditable),
        messageAttributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def messageId: Option[MessageId]
    def content: Option[Content]
    def metadata: Option[Metadata]
    def `type`: Option[zio.aws.chimesdkmessaging.model.ChannelMessageType]
    def createdTimestamp: Option[Timestamp]
    def lastUpdatedTimestamp: Option[Timestamp]
    def lastEditedTimestamp: Option[Timestamp]
    def sender: Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def redacted: Option[NonNullableBoolean]
    def status: Option[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ]
    def messageAttributes: Option[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]]
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getContent: ZIO[Any, AwsError, Content] =
      AwsError.unwrapOptionField("content", content)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMessageType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getLastEditedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastEditedTimestamp", lastEditedTimestamp)
    def getSender: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("sender", sender)
    def getRedacted: ZIO[Any, AwsError, NonNullableBoolean] =
      AwsError.unwrapOptionField("redacted", redacted)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getMessageAttributes: ZIO[Any, AwsError, Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("messageAttributes", messageAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageSummary
  ) extends zio.aws.chimesdkmessaging.model.ChannelMessageSummary.ReadOnly {
    override val messageId: Option[MessageId] = scala
      .Option(impl.messageId())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.MessageId(value))
    override val content: Option[Content] = scala
      .Option(impl.content())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Content(value))
    override val metadata: Option[Metadata] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
    override val `type`
        : Option[zio.aws.chimesdkmessaging.model.ChannelMessageType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMessageType.wrap(value)
      )
    override val createdTimestamp: Option[Timestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val lastEditedTimestamp: Option[Timestamp] = scala
      .Option(impl.lastEditedTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val sender
        : Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] = scala
      .Option(impl.sender())
      .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
    override val redacted: Option[NonNullableBoolean] = scala
      .Option(impl.redacted())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonNullableBoolean(value)
      )
    override val status: Option[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure
          .wrap(value)
      )
    override val messageAttributes: Option[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]] = scala
      .Option(impl.messageAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.chimesdkmessaging.model.primitives.MessageAttributeName(
              key
            ) -> zio.aws.chimesdkmessaging.model.MessageAttributeValue
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageSummary
  ): zio.aws.chimesdkmessaging.model.ChannelMessageSummary.ReadOnly =
    new Wrapper(impl)
}
