package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.chimesdkmessaging.model.primitives.{
  Timestamp,
  Metadata,
  ChimeArn,
  NonEmptyResourceName
}
import scala.jdk.CollectionConverters._
final case class Channel(
    name: Option[NonEmptyResourceName] = None,
    channelArn: Option[ChimeArn] = None,
    mode: Option[zio.aws.chimesdkmessaging.model.ChannelMode] = None,
    privacy: Option[zio.aws.chimesdkmessaging.model.ChannelPrivacy] = None,
    metadata: Option[Metadata] = None,
    createdBy: Option[zio.aws.chimesdkmessaging.model.Identity] = None,
    createdTimestamp: Option[Timestamp] = None,
    lastMessageTimestamp: Option[Timestamp] = None,
    lastUpdatedTimestamp: Option[Timestamp] = None,
    channelFlowArn: Option[ChimeArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.Channel = {
    import Channel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.Channel
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(privacy.map(value => value.unwrap))(_.privacy)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastMessageTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastMessageTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .optionallyWith(
        channelFlowArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelFlowArn)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.Channel.ReadOnly =
    zio.aws.chimesdkmessaging.model.Channel.wrap(buildAwsValue())
}
object Channel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.Channel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.Channel =
      zio.aws.chimesdkmessaging.model.Channel(
        name.map(value => value),
        channelArn.map(value => value),
        mode.map(value => value),
        privacy.map(value => value),
        metadata.map(value => value),
        createdBy.map(value => value.asEditable),
        createdTimestamp.map(value => value),
        lastMessageTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        channelFlowArn.map(value => value)
      )
    def name: Option[NonEmptyResourceName]
    def channelArn: Option[ChimeArn]
    def mode: Option[zio.aws.chimesdkmessaging.model.ChannelMode]
    def privacy: Option[zio.aws.chimesdkmessaging.model.ChannelPrivacy]
    def metadata: Option[Metadata]
    def createdBy: Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def createdTimestamp: Option[Timestamp]
    def lastMessageTimestamp: Option[Timestamp]
    def lastUpdatedTimestamp: Option[Timestamp]
    def channelFlowArn: Option[ChimeArn]
    def getName: ZIO[Any, AwsError, NonEmptyResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMode
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ChannelMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getPrivacy
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ChannelPrivacy] =
      AwsError.unwrapOptionField("privacy", privacy)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getCreatedBy: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastMessageTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastMessageTimestamp", lastMessageTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getChannelFlowArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelFlowArn", channelFlowArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.Channel
  ) extends zio.aws.chimesdkmessaging.model.Channel.ReadOnly {
    override val name: Option[NonEmptyResourceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonEmptyResourceName(value)
      )
    override val channelArn: Option[ChimeArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val mode: Option[zio.aws.chimesdkmessaging.model.ChannelMode] =
      scala
        .Option(impl.mode())
        .map(value => zio.aws.chimesdkmessaging.model.ChannelMode.wrap(value))
    override val privacy
        : Option[zio.aws.chimesdkmessaging.model.ChannelPrivacy] = scala
      .Option(impl.privacy())
      .map(value => zio.aws.chimesdkmessaging.model.ChannelPrivacy.wrap(value))
    override val metadata: Option[Metadata] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
    override val createdBy
        : Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
    override val createdTimestamp: Option[Timestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val lastMessageTimestamp: Option[Timestamp] = scala
      .Option(impl.lastMessageTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val channelFlowArn: Option[ChimeArn] = scala
      .Option(impl.channelFlowArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.Channel
  ): zio.aws.chimesdkmessaging.model.Channel.ReadOnly = new Wrapper(impl)
}
