package zio.aws.chimesdkmessaging.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{
  NextToken,
  MaxResults,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class ListChannelsAssociatedWithChannelFlowRequest(
    channelFlowArn: ChimeArn,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest = {
    import ListChannelsAssociatedWithChannelFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
      .builder()
      .channelFlowArn(ChimeArn.unwrap(channelFlowArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
      .wrap(buildAwsValue())
}
object ListChannelsAssociatedWithChannelFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest =
      zio.aws.chimesdkmessaging.model
        .ListChannelsAssociatedWithChannelFlowRequest(
          channelFlowArn,
          maxResults.map(value => value),
          nextToken.map(value => value)
        )
    def channelFlowArn: ChimeArn
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getChannelFlowArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(channelFlowArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
  ) extends zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest.ReadOnly {
    override val channelFlowArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelFlowArn())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
  ): zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest.ReadOnly =
    new Wrapper(impl)
}
