package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{NextToken, ChimeArn}
import scala.jdk.CollectionConverters._
final case class ListChannelBansResponse(
    channelArn: Option[ChimeArn] = None,
    nextToken: Option[NextToken] = None,
    channelBans: Option[
      Iterable[zio.aws.chimesdkmessaging.model.ChannelBanSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelBansResponse = {
    import ListChannelBansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelBansResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        channelBans.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelBans)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelBansResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelBansResponse
      .wrap(buildAwsValue())
}
object ListChannelBansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelBansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ListChannelBansResponse =
      zio.aws.chimesdkmessaging.model.ListChannelBansResponse(
        channelArn.map(value => value),
        nextToken.map(value => value),
        channelBans.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channelArn: Option[ChimeArn]
    def nextToken: Option[NextToken]
    def channelBans: Option[
      List[zio.aws.chimesdkmessaging.model.ChannelBanSummary.ReadOnly]
    ]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChannelBans: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.ChannelBanSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channelBans", channelBans)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelBansResponse
  ) extends zio.aws.chimesdkmessaging.model.ListChannelBansResponse.ReadOnly {
    override val channelArn: Option[ChimeArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
    override val channelBans: Option[
      List[zio.aws.chimesdkmessaging.model.ChannelBanSummary.ReadOnly]
    ] = scala
      .Option(impl.channelBans())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmessaging.model.ChannelBanSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelBansResponse
  ): zio.aws.chimesdkmessaging.model.ListChannelBansResponse.ReadOnly =
    new Wrapper(impl)
}
