package zio.aws.chimesdkmessaging.model
import scala.jdk.CollectionConverters._
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode
  ): zio.aws.chimesdkmessaging.model.ErrorCode = value match {
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.BAD_REQUEST =>
      val r = BadRequest
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.CONFLICT =>
      val r = Conflict
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.FORBIDDEN =>
      val r = Forbidden
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.NOT_FOUND =>
      val r = NotFound
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.PRECONDITION_FAILED =>
      val r = PreconditionFailed
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.RESOURCE_LIMIT_EXCEEDED =>
      val r = ResourceLimitExceeded
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.SERVICE_FAILURE =>
      val r = ServiceFailure
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.ACCESS_DENIED =>
      val r = AccessDenied
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.SERVICE_UNAVAILABLE =>
      val r = ServiceUnavailable
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.THROTTLED =>
      val r = Throttled
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.THROTTLING =>
      val r = Throttling
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.UNAUTHORIZED =>
      val r = Unauthorized
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.UNPROCESSABLE =>
      val r = Unprocessable
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.VOICE_CONNECTOR_GROUP_ASSOCIATIONS_EXIST =>
      val r = VoiceConnectorGroupAssociationsExist
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.PHONE_NUMBER_ASSOCIATIONS_EXIST =>
      val r = PhoneNumberAssociationsExist
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object BadRequest extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.BAD_REQUEST
  }
  case object Conflict extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.CONFLICT
  }
  case object Forbidden extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.FORBIDDEN
  }
  case object NotFound extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.NOT_FOUND
  }
  case object PreconditionFailed
      extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.PRECONDITION_FAILED
  }
  case object ResourceLimitExceeded
      extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.RESOURCE_LIMIT_EXCEEDED
  }
  case object ServiceFailure extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.SERVICE_FAILURE
  }
  case object AccessDenied extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.ACCESS_DENIED
  }
  case object ServiceUnavailable
      extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.SERVICE_UNAVAILABLE
  }
  case object Throttled extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.THROTTLED
  }
  case object Throttling extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.THROTTLING
  }
  case object Unauthorized extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.UNAUTHORIZED
  }
  case object Unprocessable extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.UNPROCESSABLE
  }
  case object VoiceConnectorGroupAssociationsExist
      extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.VOICE_CONNECTOR_GROUP_ASSOCIATIONS_EXIST
  }
  case object PhoneNumberAssociationsExist
      extends zio.aws.chimesdkmessaging.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode =
      software.amazon.awssdk.services.chimesdkmessaging.model.ErrorCode.PHONE_NUMBER_ASSOCIATIONS_EXIST
  }
}
