package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class DescribeChannelMembershipForAppInstanceUserRequest(
    channelArn: ChimeArn,
    appInstanceUserArn: ChimeArn,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest = {
    import DescribeChannelMembershipForAppInstanceUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .appInstanceUserArn(ChimeArn.unwrap(appInstanceUserArn): java.lang.String)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest
      .wrap(buildAwsValue())
}
object DescribeChannelMembershipForAppInstanceUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest =
      zio.aws.chimesdkmessaging.model
        .DescribeChannelMembershipForAppInstanceUserRequest(
          channelArn,
          appInstanceUserArn,
          chimeBearer
        )
    def channelArn: ChimeArn
    def appInstanceUserArn: ChimeArn
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getAppInstanceUserArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceUserArn)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest
  ) extends zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val appInstanceUserArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives
        .ChimeArn(impl.appInstanceUserArn())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest
  ): zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest.ReadOnly =
    new Wrapper(impl)
}
