package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class GetChannelMembershipPreferencesResponse(
    channelArn: Option[ChimeArn] = None,
    member: Option[zio.aws.chimesdkmessaging.model.Identity] = None,
    preferences: Option[
      zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse = {
    import GetChannelMembershipPreferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .optionallyWith(preferences.map(value => value.buildAwsValue()))(
        _.preferences
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse
      .wrap(buildAwsValue())
}
object GetChannelMembershipPreferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse =
      zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse(
        channelArn.map(value => value),
        member.map(value => value.asEditable),
        preferences.map(value => value.asEditable)
      )
    def channelArn: Option[ChimeArn]
    def member: Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def preferences: Option[
      zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.ReadOnly
    ]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMember: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("member", member)
    def getPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.ReadOnly
    ] = AwsError.unwrapOptionField("preferences", preferences)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse
  ) extends zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse.ReadOnly {
    override val channelArn: Option[ChimeArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val member
        : Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] = scala
      .Option(impl.member())
      .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
    override val preferences: Option[
      zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.ReadOnly
    ] = scala
      .Option(impl.preferences())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse
  ): zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse.ReadOnly =
    new Wrapper(impl)
}
