package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.chimesdkmessaging.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class AppInstanceUserMembershipSummary(
    `type`: Option[zio.aws.chimesdkmessaging.model.ChannelMembershipType] =
      None,
    readMarkerTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.AppInstanceUserMembershipSummary = {
    import AppInstanceUserMembershipSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.AppInstanceUserMembershipSummary
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        readMarkerTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.readMarkerTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary
      .wrap(buildAwsValue())
}
object AppInstanceUserMembershipSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.AppInstanceUserMembershipSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary =
      zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary(
        `type`.map(value => value),
        readMarkerTimestamp.map(value => value)
      )
    def `type`: Option[zio.aws.chimesdkmessaging.model.ChannelMembershipType]
    def readMarkerTimestamp: Option[Timestamp]
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMembershipType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getReadMarkerTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("readMarkerTimestamp", readMarkerTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.AppInstanceUserMembershipSummary
  ) extends zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary.ReadOnly {
    override val `type`
        : Option[zio.aws.chimesdkmessaging.model.ChannelMembershipType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMembershipType.wrap(value)
      )
    override val readMarkerTimestamp: Option[Timestamp] = scala
      .Option(impl.readMarkerTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.AppInstanceUserMembershipSummary
  ): zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary.ReadOnly =
    new Wrapper(impl)
}
