package zio.aws.chimesdkmessaging.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{
  NextToken,
  MaxResults,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class ListChannelMembershipsForAppInstanceUserRequest(
    appInstanceUserArn: Option[ChimeArn] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest = {
    import ListChannelMembershipsForAppInstanceUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest
      .builder()
      .optionallyWith(
        appInstanceUserArn.map(value =>
          ChimeArn.unwrap(value): java.lang.String
        )
      )(_.appInstanceUserArn)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest
      .wrap(buildAwsValue())
}
object ListChannelMembershipsForAppInstanceUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest =
      zio.aws.chimesdkmessaging.model
        .ListChannelMembershipsForAppInstanceUserRequest(
          appInstanceUserArn.map(value => value),
          maxResults.map(value => value),
          nextToken.map(value => value),
          chimeBearer
        )
    def appInstanceUserArn: Option[ChimeArn]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def chimeBearer: ChimeArn
    def getAppInstanceUserArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("appInstanceUserArn", appInstanceUserArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest
  ) extends zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest.ReadOnly {
    override val appInstanceUserArn: Option[ChimeArn] = scala
      .Option(impl.appInstanceUserArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest
  ): zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest.ReadOnly =
    new Wrapper(impl)
}
