package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class BatchCreateChannelMembershipError(
    memberArn: Option[ChimeArn] = None,
    errorCode: Option[zio.aws.chimesdkmessaging.model.ErrorCode] = None,
    errorMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipError = {
    import BatchCreateChannelMembershipError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipError
      .builder()
      .optionallyWith(
        memberArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.memberArn)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError.ReadOnly =
    zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError
      .wrap(buildAwsValue())
}
object BatchCreateChannelMembershipError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError =
      zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError(
        memberArn.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def memberArn: Option[ChimeArn]
    def errorCode: Option[zio.aws.chimesdkmessaging.model.ErrorCode]
    def errorMessage: Option[String]
    def getMemberArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("memberArn", memberArn)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipError
  ) extends zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError.ReadOnly {
    override val memberArn: Option[ChimeArn] = scala
      .Option(impl.memberArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val errorCode: Option[zio.aws.chimesdkmessaging.model.ErrorCode] =
      scala
        .Option(impl.errorCode())
        .map(value => zio.aws.chimesdkmessaging.model.ErrorCode.wrap(value))
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipError
  ): zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError.ReadOnly =
    new Wrapper(impl)
}
