package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.chimesdkmessaging.model.primitives.{Timestamp, ChimeArn}
import scala.jdk.CollectionConverters._
final case class ChannelMembership(
    invitedBy: Option[zio.aws.chimesdkmessaging.model.Identity] = None,
    `type`: Option[zio.aws.chimesdkmessaging.model.ChannelMembershipType] =
      None,
    member: Option[zio.aws.chimesdkmessaging.model.Identity] = None,
    channelArn: Option[ChimeArn] = None,
    createdTimestamp: Option[Timestamp] = None,
    lastUpdatedTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembership = {
    import ChannelMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembership
      .builder()
      .optionallyWith(invitedBy.map(value => value.buildAwsValue()))(
        _.invitedBy
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.ChannelMembership.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelMembership.wrap(buildAwsValue())
}
object ChannelMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelMembership =
      zio.aws.chimesdkmessaging.model.ChannelMembership(
        invitedBy.map(value => value.asEditable),
        `type`.map(value => value),
        member.map(value => value.asEditable),
        channelArn.map(value => value),
        createdTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value)
      )
    def invitedBy: Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def `type`: Option[zio.aws.chimesdkmessaging.model.ChannelMembershipType]
    def member: Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def channelArn: Option[ChimeArn]
    def createdTimestamp: Option[Timestamp]
    def lastUpdatedTimestamp: Option[Timestamp]
    def getInvitedBy: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("invitedBy", invitedBy)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMembershipType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getMember: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("member", member)
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembership
  ) extends zio.aws.chimesdkmessaging.model.ChannelMembership.ReadOnly {
    override val invitedBy
        : Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] = scala
      .Option(impl.invitedBy())
      .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
    override val `type`
        : Option[zio.aws.chimesdkmessaging.model.ChannelMembershipType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMembershipType.wrap(value)
      )
    override val member
        : Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] = scala
      .Option(impl.member())
      .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
    override val channelArn: Option[ChimeArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val createdTimestamp: Option[Timestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembership
  ): zio.aws.chimesdkmessaging.model.ChannelMembership.ReadOnly = new Wrapper(
    impl
  )
}
