package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceARN: ChimeArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(ChimeArn.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ListTagsForResourceRequest =
      zio.aws.chimesdkmessaging.model.ListTagsForResourceRequest(resourceARN)
    def resourceARN: ChimeArn
    def getResourceARN: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListTagsForResourceRequest
  ) extends zio.aws.chimesdkmessaging.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListTagsForResourceRequest
  ): zio.aws.chimesdkmessaging.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
