package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{CallbackIdType, ChimeArn}
import scala.jdk.CollectionConverters._
final case class ChannelFlowCallbackResponse(
    channelArn: Option[ChimeArn] = None,
    callbackId: Option[CallbackIdType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackResponse = {
    import ChannelFlowCallbackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        callbackId.map(value => CallbackIdType.unwrap(value): java.lang.String)
      )(_.callbackId)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse
      .wrap(buildAwsValue())
}
object ChannelFlowCallbackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse =
      zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse(
        channelArn.map(value => value),
        callbackId.map(value => value)
      )
    def channelArn: Option[ChimeArn]
    def callbackId: Option[CallbackIdType]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getCallbackId: ZIO[Any, AwsError, CallbackIdType] =
      AwsError.unwrapOptionField("callbackId", callbackId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackResponse
  ) extends zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse.ReadOnly {
    override val channelArn: Option[ChimeArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val callbackId: Option[CallbackIdType] = scala
      .Option(impl.callbackId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.CallbackIdType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackResponse
  ): zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse.ReadOnly =
    new Wrapper(impl)
}
