package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{
  NonNullableBoolean,
  ChimeArn,
  CallbackIdType
}
import scala.jdk.CollectionConverters._
final case class ChannelFlowCallbackRequest(
    callbackId: CallbackIdType,
    channelArn: ChimeArn,
    deleteResource: Option[NonNullableBoolean] = None,
    channelMessage: zio.aws.chimesdkmessaging.model.ChannelMessageCallback
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackRequest = {
    import ChannelFlowCallbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackRequest
      .builder()
      .callbackId(CallbackIdType.unwrap(callbackId): java.lang.String)
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(
        deleteResource.map(value =>
          NonNullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.deleteResource)
      .channelMessage(channelMessage.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelFlowCallbackRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelFlowCallbackRequest
      .wrap(buildAwsValue())
}
object ChannelFlowCallbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelFlowCallbackRequest =
      zio.aws.chimesdkmessaging.model.ChannelFlowCallbackRequest(
        callbackId,
        channelArn,
        deleteResource.map(value => value),
        channelMessage.asEditable
      )
    def callbackId: CallbackIdType
    def channelArn: ChimeArn
    def deleteResource: Option[NonNullableBoolean]
    def channelMessage
        : zio.aws.chimesdkmessaging.model.ChannelMessageCallback.ReadOnly
    def getCallbackId: ZIO[Any, Nothing, CallbackIdType] =
      ZIO.succeed(callbackId)
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getDeleteResource: ZIO[Any, AwsError, NonNullableBoolean] =
      AwsError.unwrapOptionField("deleteResource", deleteResource)
    def getChannelMessage: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmessaging.model.ChannelMessageCallback.ReadOnly
    ] = ZIO.succeed(channelMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackRequest
  ) extends zio.aws.chimesdkmessaging.model.ChannelFlowCallbackRequest.ReadOnly {
    override val callbackId: CallbackIdType =
      zio.aws.chimesdkmessaging.model.primitives
        .CallbackIdType(impl.callbackId())
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val deleteResource: Option[NonNullableBoolean] = scala
      .Option(impl.deleteResource())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonNullableBoolean(value)
      )
    override val channelMessage
        : zio.aws.chimesdkmessaging.model.ChannelMessageCallback.ReadOnly =
      zio.aws.chimesdkmessaging.model.ChannelMessageCallback
        .wrap(impl.channelMessage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackRequest
  ): zio.aws.chimesdkmessaging.model.ChannelFlowCallbackRequest.ReadOnly =
    new Wrapper(impl)
}
