package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.StatusDetail
import scala.jdk.CollectionConverters._
final case class ChannelMessageStatusStructure(
    value: Option[zio.aws.chimesdkmessaging.model.ChannelMessageStatus] = None,
    detail: Option[StatusDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageStatusStructure = {
    import ChannelMessageStatusStructure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageStatusStructure
      .builder()
      .optionallyWith(value.map(value => value.unwrap))(_.value)
      .optionallyWith(
        detail.map(value => StatusDetail.unwrap(value): java.lang.String)
      )(_.detail)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure
      .wrap(buildAwsValue())
}
object ChannelMessageStatusStructure {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageStatusStructure
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure =
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure(
        value.map(value => value),
        detail.map(value => value)
      )
    def value: Option[zio.aws.chimesdkmessaging.model.ChannelMessageStatus]
    def detail: Option[StatusDetail]
    def getValue: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMessageStatus
    ] = AwsError.unwrapOptionField("value", value)
    def getDetail: ZIO[Any, AwsError, StatusDetail] =
      AwsError.unwrapOptionField("detail", detail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageStatusStructure
  ) extends zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly {
    override val value
        : Option[zio.aws.chimesdkmessaging.model.ChannelMessageStatus] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMessageStatus.wrap(value)
      )
    override val detail: Option[StatusDetail] = scala
      .Option(impl.detail())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.StatusDetail(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageStatusStructure
  ): zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly =
    new Wrapper(impl)
}
