package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeChannelFlowResponse(
    channelFlow: Option[zio.aws.chimesdkmessaging.model.ChannelFlow] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowResponse = {
    import DescribeChannelFlowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowResponse
      .builder()
      .optionallyWith(channelFlow.map(value => value.buildAwsValue()))(
        _.channelFlow
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse
      .wrap(buildAwsValue())
}
object DescribeChannelFlowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse =
      zio.aws.chimesdkmessaging.model
        .DescribeChannelFlowResponse(channelFlow.map(value => value.asEditable))
    def channelFlow
        : Option[zio.aws.chimesdkmessaging.model.ChannelFlow.ReadOnly]
    def getChannelFlow: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelFlow.ReadOnly
    ] = AwsError.unwrapOptionField("channelFlow", channelFlow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowResponse
  ) extends zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse.ReadOnly {
    override val channelFlow
        : Option[zio.aws.chimesdkmessaging.model.ChannelFlow.ReadOnly] = scala
      .Option(impl.channelFlow())
      .map(value => zio.aws.chimesdkmessaging.model.ChannelFlow.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowResponse
  ): zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse.ReadOnly =
    new Wrapper(impl)
}
