package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.chimesdkmessaging.model.primitives.{Timestamp, ChimeArn}
import scala.jdk.CollectionConverters._
final case class ChannelBan(
    member: Option[zio.aws.chimesdkmessaging.model.Identity] = None,
    channelArn: Option[ChimeArn] = None,
    createdTimestamp: Option[Timestamp] = None,
    createdBy: Option[zio.aws.chimesdkmessaging.model.Identity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelBan = {
    import ChannelBan.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelBan
      .builder()
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.ChannelBan.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelBan.wrap(buildAwsValue())
}
object ChannelBan {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelBan
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelBan =
      zio.aws.chimesdkmessaging.model.ChannelBan(
        member.map(value => value.asEditable),
        channelArn.map(value => value),
        createdTimestamp.map(value => value),
        createdBy.map(value => value.asEditable)
      )
    def member: Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def channelArn: Option[ChimeArn]
    def createdTimestamp: Option[Timestamp]
    def createdBy: Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def getMember: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("member", member)
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getCreatedBy: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelBan
  ) extends zio.aws.chimesdkmessaging.model.ChannelBan.ReadOnly {
    override val member
        : Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] = scala
      .Option(impl.member())
      .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
    override val channelArn: Option[ChimeArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val createdTimestamp: Option[Timestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val createdBy
        : Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelBan
  ): zio.aws.chimesdkmessaging.model.ChannelBan.ReadOnly = new Wrapper(impl)
}
