package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ProcessorConfiguration(
    lambda: zio.aws.chimesdkmessaging.model.LambdaConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ProcessorConfiguration = {
    import ProcessorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ProcessorConfiguration
      .builder()
      .lambda(lambda.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ProcessorConfiguration.ReadOnly =
    zio.aws.chimesdkmessaging.model.ProcessorConfiguration.wrap(buildAwsValue())
}
object ProcessorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ProcessorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ProcessorConfiguration =
      zio.aws.chimesdkmessaging.model.ProcessorConfiguration(lambda.asEditable)
    def lambda: zio.aws.chimesdkmessaging.model.LambdaConfiguration.ReadOnly
    def getLambda: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmessaging.model.LambdaConfiguration.ReadOnly
    ] = ZIO.succeed(lambda)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ProcessorConfiguration
  ) extends zio.aws.chimesdkmessaging.model.ProcessorConfiguration.ReadOnly {
    override val lambda
        : zio.aws.chimesdkmessaging.model.LambdaConfiguration.ReadOnly =
      zio.aws.chimesdkmessaging.model.LambdaConfiguration.wrap(impl.lambda())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ProcessorConfiguration
  ): zio.aws.chimesdkmessaging.model.ProcessorConfiguration.ReadOnly =
    new Wrapper(impl)
}
