package zio.aws.chimesdkmessaging.model
import zio.aws.chimesdkmessaging.model.primitives.{
  NextToken,
  MaxResults,
  Timestamp,
  ChimeArn
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListChannelMessagesRequest(
    channelArn: ChimeArn,
    sortOrder: Option[zio.aws.chimesdkmessaging.model.SortOrder] = None,
    notBefore: Option[Timestamp] = None,
    notAfter: Option[Timestamp] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMessagesRequest = {
    import ListChannelMessagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMessagesRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(notBefore.map(value => Timestamp.unwrap(value): Instant))(
        _.notBefore
      )
      .optionallyWith(notAfter.map(value => Timestamp.unwrap(value): Instant))(
        _.notAfter
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelMessagesRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelMessagesRequest
      .wrap(buildAwsValue())
}
object ListChannelMessagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMessagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ListChannelMessagesRequest =
      zio.aws.chimesdkmessaging.model.ListChannelMessagesRequest(
        channelArn,
        sortOrder.map(value => value),
        notBefore.map(value => value),
        notAfter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        chimeBearer
      )
    def channelArn: ChimeArn
    def sortOrder: Option[zio.aws.chimesdkmessaging.model.SortOrder]
    def notBefore: Option[Timestamp]
    def notAfter: Option[Timestamp]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNotBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getNotAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMessagesRequest
  ) extends zio.aws.chimesdkmessaging.model.ListChannelMessagesRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val sortOrder: Option[zio.aws.chimesdkmessaging.model.SortOrder] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.chimesdkmessaging.model.SortOrder.wrap(value))
    override val notBefore: Option[Timestamp] = scala
      .Option(impl.notBefore())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val notAfter: Option[Timestamp] = scala
      .Option(impl.notAfter())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMessagesRequest
  ): zio.aws.chimesdkmessaging.model.ListChannelMessagesRequest.ReadOnly =
    new Wrapper(impl)
}
