package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{
  NonEmptyResourceName,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class ChannelFlowSummary(
    channelFlowArn: Option[ChimeArn] = None,
    name: Option[NonEmptyResourceName] = None,
    processors: Option[Iterable[zio.aws.chimesdkmessaging.model.Processor]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowSummary = {
    import ChannelFlowSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowSummary
      .builder()
      .optionallyWith(
        channelFlowArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelFlowArn)
      .optionallyWith(
        name.map(value => NonEmptyResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        processors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processors)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.ChannelFlowSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelFlowSummary.wrap(buildAwsValue())
}
object ChannelFlowSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelFlowSummary =
      zio.aws.chimesdkmessaging.model.ChannelFlowSummary(
        channelFlowArn.map(value => value),
        name.map(value => value),
        processors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channelFlowArn: Option[ChimeArn]
    def name: Option[NonEmptyResourceName]
    def processors
        : Option[List[zio.aws.chimesdkmessaging.model.Processor.ReadOnly]]
    def getChannelFlowArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelFlowArn", channelFlowArn)
    def getName: ZIO[Any, AwsError, NonEmptyResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getProcessors: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.Processor.ReadOnly
    ]] = AwsError.unwrapOptionField("processors", processors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowSummary
  ) extends zio.aws.chimesdkmessaging.model.ChannelFlowSummary.ReadOnly {
    override val channelFlowArn: Option[ChimeArn] = scala
      .Option(impl.channelFlowArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val name: Option[NonEmptyResourceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonEmptyResourceName(value)
      )
    override val processors
        : Option[List[zio.aws.chimesdkmessaging.model.Processor.ReadOnly]] =
      scala
        .Option(impl.processors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmessaging.model.Processor.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowSummary
  ): zio.aws.chimesdkmessaging.model.ChannelFlowSummary.ReadOnly = new Wrapper(
    impl
  )
}
