package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class CreateChannelBanResponse(
    channelArn: Option[ChimeArn] = None,
    member: Option[zio.aws.chimesdkmessaging.model.Identity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelBanResponse = {
    import CreateChannelBanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelBanResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.CreateChannelBanResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.CreateChannelBanResponse
      .wrap(buildAwsValue())
}
object CreateChannelBanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelBanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.CreateChannelBanResponse =
      zio.aws.chimesdkmessaging.model.CreateChannelBanResponse(
        channelArn.map(value => value),
        member.map(value => value.asEditable)
      )
    def channelArn: Option[ChimeArn]
    def member: Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMember: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("member", member)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelBanResponse
  ) extends zio.aws.chimesdkmessaging.model.CreateChannelBanResponse.ReadOnly {
    override val channelArn: Option[ChimeArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val member
        : Option[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] = scala
      .Option(impl.member())
      .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelBanResponse
  ): zio.aws.chimesdkmessaging.model.CreateChannelBanResponse.ReadOnly =
    new Wrapper(impl)
}
