package zio.aws.chimesdkmessaging.model
import scala.jdk.CollectionConverters._
sealed trait AllowNotifications {
  def unwrap: software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications
}
object AllowNotifications {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications
  ): zio.aws.chimesdkmessaging.model.AllowNotifications = value match {
    case software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications.FILTERED =>
      val r = FILTERED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmessaging.model.AllowNotifications {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications =
      software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.chimesdkmessaging.model.AllowNotifications {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications =
      software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications.ALL
  }
  case object NONE extends zio.aws.chimesdkmessaging.model.AllowNotifications {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications =
      software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications.NONE
  }
  case object FILTERED
      extends zio.aws.chimesdkmessaging.model.AllowNotifications {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications =
      software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications.FILTERED
  }
}
