package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmeetings.model.primitives.{
  TranscribeVocabularyNamesOrFilterNamesString,
  TranscribeLanguageOptions,
  TranscribeLanguageModelName,
  TranscribePiiEntityTypes
}
import scala.jdk.CollectionConverters._
final case class EngineTranscribeSettings(
    languageCode: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeLanguageCode
    ] = Optional.Absent,
    vocabularyFilterMethod: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeVocabularyFilterMethod
    ] = Optional.Absent,
    vocabularyFilterName: Optional[String] = Optional.Absent,
    vocabularyName: Optional[String] = Optional.Absent,
    region: Optional[zio.aws.chimesdkmeetings.model.TranscribeRegion] =
      Optional.Absent,
    enablePartialResultsStabilization: Optional[Boolean] = Optional.Absent,
    partialResultsStability: Optional[
      zio.aws.chimesdkmeetings.model.TranscribePartialResultsStability
    ] = Optional.Absent,
    contentIdentificationType: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeContentIdentificationType
    ] = Optional.Absent,
    contentRedactionType: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeContentRedactionType
    ] = Optional.Absent,
    piiEntityTypes: Optional[TranscribePiiEntityTypes] = Optional.Absent,
    languageModelName: Optional[TranscribeLanguageModelName] = Optional.Absent,
    identifyLanguage: Optional[Boolean] = Optional.Absent,
    languageOptions: Optional[TranscribeLanguageOptions] = Optional.Absent,
    preferredLanguage: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeLanguageCode
    ] = Optional.Absent,
    vocabularyNames: Optional[TranscribeVocabularyNamesOrFilterNamesString] =
      Optional.Absent,
    vocabularyFilterNames: Optional[
      TranscribeVocabularyNamesOrFilterNamesString
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeSettings = {
    import EngineTranscribeSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeSettings
      .builder()
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(vocabularyFilterMethod.map(value => value.unwrap))(
        _.vocabularyFilterMethod
      )
      .optionallyWith(
        vocabularyFilterName.map(value => value: java.lang.String)
      )(_.vocabularyFilterName)
      .optionallyWith(vocabularyName.map(value => value: java.lang.String))(
        _.vocabularyName
      )
      .optionallyWith(region.map(value => value.unwrap))(_.region)
      .optionallyWith(
        enablePartialResultsStabilization.map(value => value: java.lang.Boolean)
      )(_.enablePartialResultsStabilization)
      .optionallyWith(partialResultsStability.map(value => value.unwrap))(
        _.partialResultsStability
      )
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .optionallyWith(contentRedactionType.map(value => value.unwrap))(
        _.contentRedactionType
      )
      .optionallyWith(
        piiEntityTypes.map(value =>
          TranscribePiiEntityTypes.unwrap(value): java.lang.String
        )
      )(_.piiEntityTypes)
      .optionallyWith(
        languageModelName.map(value =>
          TranscribeLanguageModelName.unwrap(value): java.lang.String
        )
      )(_.languageModelName)
      .optionallyWith(identifyLanguage.map(value => value: java.lang.Boolean))(
        _.identifyLanguage
      )
      .optionallyWith(
        languageOptions.map(value =>
          TranscribeLanguageOptions.unwrap(value): java.lang.String
        )
      )(_.languageOptions)
      .optionallyWith(preferredLanguage.map(value => value.unwrap))(
        _.preferredLanguage
      )
      .optionallyWith(
        vocabularyNames.map(value =>
          TranscribeVocabularyNamesOrFilterNamesString.unwrap(
            value
          ): java.lang.String
        )
      )(_.vocabularyNames)
      .optionallyWith(
        vocabularyFilterNames.map(value =>
          TranscribeVocabularyNamesOrFilterNamesString.unwrap(
            value
          ): java.lang.String
        )
      )(_.vocabularyFilterNames)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.EngineTranscribeSettings.ReadOnly =
    zio.aws.chimesdkmeetings.model.EngineTranscribeSettings
      .wrap(buildAwsValue())
}
object EngineTranscribeSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.EngineTranscribeSettings =
      zio.aws.chimesdkmeetings.model.EngineTranscribeSettings(
        languageCode.map(value => value),
        vocabularyFilterMethod.map(value => value),
        vocabularyFilterName.map(value => value),
        vocabularyName.map(value => value),
        region.map(value => value),
        enablePartialResultsStabilization.map(value => value),
        partialResultsStability.map(value => value),
        contentIdentificationType.map(value => value),
        contentRedactionType.map(value => value),
        piiEntityTypes.map(value => value),
        languageModelName.map(value => value),
        identifyLanguage.map(value => value),
        languageOptions.map(value => value),
        preferredLanguage.map(value => value),
        vocabularyNames.map(value => value),
        vocabularyFilterNames.map(value => value)
      )
    def languageCode
        : Optional[zio.aws.chimesdkmeetings.model.TranscribeLanguageCode]
    def vocabularyFilterMethod: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeVocabularyFilterMethod
    ]
    def vocabularyFilterName: Optional[String]
    def vocabularyName: Optional[String]
    def region: Optional[zio.aws.chimesdkmeetings.model.TranscribeRegion]
    def enablePartialResultsStabilization: Optional[Boolean]
    def partialResultsStability: Optional[
      zio.aws.chimesdkmeetings.model.TranscribePartialResultsStability
    ]
    def contentIdentificationType: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeContentIdentificationType
    ]
    def contentRedactionType: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeContentRedactionType
    ]
    def piiEntityTypes: Optional[TranscribePiiEntityTypes]
    def languageModelName: Optional[TranscribeLanguageModelName]
    def identifyLanguage: Optional[Boolean]
    def languageOptions: Optional[TranscribeLanguageOptions]
    def preferredLanguage
        : Optional[zio.aws.chimesdkmeetings.model.TranscribeLanguageCode]
    def vocabularyNames: Optional[TranscribeVocabularyNamesOrFilterNamesString]
    def vocabularyFilterNames
        : Optional[TranscribeVocabularyNamesOrFilterNamesString]
    def getLanguageCode: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribeLanguageCode
    ] = AwsError.unwrapOptionField("languageCode", languageCode)
    def getVocabularyFilterMethod: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribeVocabularyFilterMethod
    ] = AwsError.unwrapOptionField(
      "vocabularyFilterMethod",
      vocabularyFilterMethod
    )
    def getVocabularyFilterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getVocabularyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getRegion
        : ZIO[Any, AwsError, zio.aws.chimesdkmeetings.model.TranscribeRegion] =
      AwsError.unwrapOptionField("region", region)
    def getEnablePartialResultsStabilization: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enablePartialResultsStabilization",
        enablePartialResultsStabilization
      )
    def getPartialResultsStability: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribePartialResultsStability
    ] = AwsError.unwrapOptionField(
      "partialResultsStability",
      partialResultsStability
    )
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribeContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
    def getContentRedactionType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribeContentRedactionType
    ] = AwsError.unwrapOptionField("contentRedactionType", contentRedactionType)
    def getPiiEntityTypes: ZIO[Any, AwsError, TranscribePiiEntityTypes] =
      AwsError.unwrapOptionField("piiEntityTypes", piiEntityTypes)
    def getLanguageModelName: ZIO[Any, AwsError, TranscribeLanguageModelName] =
      AwsError.unwrapOptionField("languageModelName", languageModelName)
    def getIdentifyLanguage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("identifyLanguage", identifyLanguage)
    def getLanguageOptions: ZIO[Any, AwsError, TranscribeLanguageOptions] =
      AwsError.unwrapOptionField("languageOptions", languageOptions)
    def getPreferredLanguage: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribeLanguageCode
    ] = AwsError.unwrapOptionField("preferredLanguage", preferredLanguage)
    def getVocabularyNames
        : ZIO[Any, AwsError, TranscribeVocabularyNamesOrFilterNamesString] =
      AwsError.unwrapOptionField("vocabularyNames", vocabularyNames)
    def getVocabularyFilterNames
        : ZIO[Any, AwsError, TranscribeVocabularyNamesOrFilterNamesString] =
      AwsError.unwrapOptionField("vocabularyFilterNames", vocabularyFilterNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeSettings
  ) extends zio.aws.chimesdkmeetings.model.EngineTranscribeSettings.ReadOnly {
    override val languageCode
        : Optional[zio.aws.chimesdkmeetings.model.TranscribeLanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value =>
          zio.aws.chimesdkmeetings.model.TranscribeLanguageCode.wrap(value)
        )
    override val vocabularyFilterMethod: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeVocabularyFilterMethod
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyFilterMethod())
      .map(value =>
        zio.aws.chimesdkmeetings.model.TranscribeVocabularyFilterMethod
          .wrap(value)
      )
    override val vocabularyFilterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyFilterName())
      .map(value => value: String)
    override val vocabularyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyName())
      .map(value => value: String)
    override val region
        : Optional[zio.aws.chimesdkmeetings.model.TranscribeRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.region())
        .map(value =>
          zio.aws.chimesdkmeetings.model.TranscribeRegion.wrap(value)
        )
    override val enablePartialResultsStabilization: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePartialResultsStabilization())
        .map(value => value: Boolean)
    override val partialResultsStability: Optional[
      zio.aws.chimesdkmeetings.model.TranscribePartialResultsStability
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.partialResultsStability())
      .map(value =>
        zio.aws.chimesdkmeetings.model.TranscribePartialResultsStability
          .wrap(value)
      )
    override val contentIdentificationType: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeContentIdentificationType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contentIdentificationType())
      .map(value =>
        zio.aws.chimesdkmeetings.model.TranscribeContentIdentificationType
          .wrap(value)
      )
    override val contentRedactionType: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeContentRedactionType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contentRedactionType())
      .map(value =>
        zio.aws.chimesdkmeetings.model.TranscribeContentRedactionType
          .wrap(value)
      )
    override val piiEntityTypes: Optional[TranscribePiiEntityTypes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.piiEntityTypes())
        .map(value =>
          zio.aws.chimesdkmeetings.model.primitives
            .TranscribePiiEntityTypes(value)
        )
    override val languageModelName: Optional[TranscribeLanguageModelName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageModelName())
        .map(value =>
          zio.aws.chimesdkmeetings.model.primitives
            .TranscribeLanguageModelName(value)
        )
    override val identifyLanguage: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.identifyLanguage())
      .map(value => value: Boolean)
    override val languageOptions: Optional[TranscribeLanguageOptions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageOptions())
        .map(value =>
          zio.aws.chimesdkmeetings.model.primitives
            .TranscribeLanguageOptions(value)
        )
    override val preferredLanguage
        : Optional[zio.aws.chimesdkmeetings.model.TranscribeLanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredLanguage())
        .map(value =>
          zio.aws.chimesdkmeetings.model.TranscribeLanguageCode.wrap(value)
        )
    override val vocabularyNames
        : Optional[TranscribeVocabularyNamesOrFilterNamesString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyNames())
        .map(value =>
          zio.aws.chimesdkmeetings.model.primitives
            .TranscribeVocabularyNamesOrFilterNamesString(value)
        )
    override val vocabularyFilterNames
        : Optional[TranscribeVocabularyNamesOrFilterNamesString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterNames())
        .map(value =>
          zio.aws.chimesdkmeetings.model.primitives
            .TranscribeVocabularyNamesOrFilterNamesString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeSettings
  ): zio.aws.chimesdkmeetings.model.EngineTranscribeSettings.ReadOnly =
    new Wrapper(impl)
}
