package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmeetings.model.primitives.GuidString
import scala.jdk.CollectionConverters._
final case class BatchUpdateAttendeeCapabilitiesExceptRequest(
    meetingId: GuidString,
    excludedAttendeeIds: Iterable[
      zio.aws.chimesdkmeetings.model.AttendeeIdItem
    ],
    capabilities: zio.aws.chimesdkmeetings.model.AttendeeCapabilities
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest = {
    import BatchUpdateAttendeeCapabilitiesExceptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .excludedAttendeeIds(excludedAttendeeIds.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .capabilities(capabilities.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest
      .wrap(buildAwsValue())
}
object BatchUpdateAttendeeCapabilitiesExceptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest =
      zio.aws.chimesdkmeetings.model
        .BatchUpdateAttendeeCapabilitiesExceptRequest(
          meetingId,
          excludedAttendeeIds.map { item =>
            item.asEditable
          },
          capabilities.asEditable
        )
    def meetingId: GuidString
    def excludedAttendeeIds
        : List[zio.aws.chimesdkmeetings.model.AttendeeIdItem.ReadOnly]
    def capabilities
        : zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getExcludedAttendeeIds: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmeetings.model.AttendeeIdItem.ReadOnly
    ]] = ZIO.succeed(excludedAttendeeIds)
    def getCapabilities: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly
    ] = ZIO.succeed(capabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest
  ) extends zio.aws.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.meetingId())
    override val excludedAttendeeIds
        : List[zio.aws.chimesdkmeetings.model.AttendeeIdItem.ReadOnly] = impl
      .excludedAttendeeIds()
      .asScala
      .map { item =>
        zio.aws.chimesdkmeetings.model.AttendeeIdItem.wrap(item)
      }
      .toList
    override val capabilities
        : zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly =
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities
        .wrap(impl.capabilities())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest
  ): zio.aws.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest.ReadOnly =
    new Wrapper(impl)
}
