package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmeetings.model.primitives.{
  JoinTokenString,
  GuidString,
  ExternalUserId
}
import scala.jdk.CollectionConverters._
final case class Attendee(
    externalUserId: Optional[ExternalUserId] = Optional.Absent,
    attendeeId: Optional[GuidString] = Optional.Absent,
    joinToken: Optional[JoinTokenString] = Optional.Absent,
    capabilities: Optional[
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.Attendee = {
    import Attendee.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.Attendee
      .builder()
      .optionallyWith(
        externalUserId.map(value =>
          ExternalUserId.unwrap(value): java.lang.String
        )
      )(_.externalUserId)
      .optionallyWith(
        attendeeId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.attendeeId)
      .optionallyWith(
        joinToken.map(value => JoinTokenString.unwrap(value): java.lang.String)
      )(_.joinToken)
      .optionallyWith(capabilities.map(value => value.buildAwsValue()))(
        _.capabilities
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.Attendee.ReadOnly =
    zio.aws.chimesdkmeetings.model.Attendee.wrap(buildAwsValue())
}
object Attendee {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.Attendee
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.Attendee =
      zio.aws.chimesdkmeetings.model.Attendee(
        externalUserId.map(value => value),
        attendeeId.map(value => value),
        joinToken.map(value => value),
        capabilities.map(value => value.asEditable)
      )
    def externalUserId: Optional[ExternalUserId]
    def attendeeId: Optional[GuidString]
    def joinToken: Optional[JoinTokenString]
    def capabilities
        : Optional[zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly]
    def getExternalUserId: ZIO[Any, AwsError, ExternalUserId] =
      AwsError.unwrapOptionField("externalUserId", externalUserId)
    def getAttendeeId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("attendeeId", attendeeId)
    def getJoinToken: ZIO[Any, AwsError, JoinTokenString] =
      AwsError.unwrapOptionField("joinToken", joinToken)
    def getCapabilities: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly
    ] = AwsError.unwrapOptionField("capabilities", capabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.Attendee
  ) extends zio.aws.chimesdkmeetings.model.Attendee.ReadOnly {
    override val externalUserId: Optional[ExternalUserId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalUserId())
        .map(value =>
          zio.aws.chimesdkmeetings.model.primitives.ExternalUserId(value)
        )
    override val attendeeId: Optional[GuidString] = zio.aws.core.internal
      .optionalFromNullable(impl.attendeeId())
      .map(value => zio.aws.chimesdkmeetings.model.primitives.GuidString(value))
    override val joinToken: Optional[JoinTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.joinToken())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives.JoinTokenString(value)
      )
    override val capabilities: Optional[
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capabilities())
      .map(value =>
        zio.aws.chimesdkmeetings.model.AttendeeCapabilities.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.Attendee
  ): zio.aws.chimesdkmeetings.model.Attendee.ReadOnly = new Wrapper(impl)
}
