package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmeetings.model.primitives.AmazonResourceName
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceARN: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.ListTagsForResourceRequest =
      zio.aws.chimesdkmeetings.model.ListTagsForResourceRequest(resourceARN)
    def resourceARN: AmazonResourceName
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.ListTagsForResourceRequest
  ) extends zio.aws.chimesdkmeetings.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.chimesdkmeetings.model.primitives
        .AmazonResourceName(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.ListTagsForResourceRequest
  ): zio.aws.chimesdkmeetings.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
