package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MeetingFeaturesConfiguration(
    audio: Optional[zio.aws.chimesdkmeetings.model.AudioFeatures] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.MeetingFeaturesConfiguration = {
    import MeetingFeaturesConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.MeetingFeaturesConfiguration
      .builder()
      .optionallyWith(audio.map(value => value.buildAwsValue()))(_.audio)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly =
    zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration
      .wrap(buildAwsValue())
}
object MeetingFeaturesConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.MeetingFeaturesConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration =
      zio.aws.chimesdkmeetings.model
        .MeetingFeaturesConfiguration(audio.map(value => value.asEditable))
    def audio: Optional[zio.aws.chimesdkmeetings.model.AudioFeatures.ReadOnly]
    def getAudio: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.AudioFeatures.ReadOnly
    ] = AwsError.unwrapOptionField("audio", audio)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.MeetingFeaturesConfiguration
  ) extends zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly {
    override val audio
        : Optional[zio.aws.chimesdkmeetings.model.AudioFeatures.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.audio())
        .map(value => zio.aws.chimesdkmeetings.model.AudioFeatures.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.MeetingFeaturesConfiguration
  ): zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly =
    new Wrapper(impl)
}
