package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TranscriptionConfiguration(
    engineTranscribeSettings: Optional[
      zio.aws.chimesdkmeetings.model.EngineTranscribeSettings
    ] = Optional.Absent,
    engineTranscribeMedicalSettings: Optional[
      zio.aws.chimesdkmeetings.model.EngineTranscribeMedicalSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.TranscriptionConfiguration = {
    import TranscriptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.TranscriptionConfiguration
      .builder()
      .optionallyWith(
        engineTranscribeSettings.map(value => value.buildAwsValue())
      )(_.engineTranscribeSettings)
      .optionallyWith(
        engineTranscribeMedicalSettings.map(value => value.buildAwsValue())
      )(_.engineTranscribeMedicalSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.TranscriptionConfiguration.ReadOnly =
    zio.aws.chimesdkmeetings.model.TranscriptionConfiguration
      .wrap(buildAwsValue())
}
object TranscriptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.TranscriptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.TranscriptionConfiguration =
      zio.aws.chimesdkmeetings.model.TranscriptionConfiguration(
        engineTranscribeSettings.map(value => value.asEditable),
        engineTranscribeMedicalSettings.map(value => value.asEditable)
      )
    def engineTranscribeSettings: Optional[
      zio.aws.chimesdkmeetings.model.EngineTranscribeSettings.ReadOnly
    ]
    def engineTranscribeMedicalSettings: Optional[
      zio.aws.chimesdkmeetings.model.EngineTranscribeMedicalSettings.ReadOnly
    ]
    def getEngineTranscribeSettings: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.EngineTranscribeSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "engineTranscribeSettings",
      engineTranscribeSettings
    )
    def getEngineTranscribeMedicalSettings: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.EngineTranscribeMedicalSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "engineTranscribeMedicalSettings",
      engineTranscribeMedicalSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.TranscriptionConfiguration
  ) extends zio.aws.chimesdkmeetings.model.TranscriptionConfiguration.ReadOnly {
    override val engineTranscribeSettings: Optional[
      zio.aws.chimesdkmeetings.model.EngineTranscribeSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.engineTranscribeSettings())
      .map(value =>
        zio.aws.chimesdkmeetings.model.EngineTranscribeSettings.wrap(value)
      )
    override val engineTranscribeMedicalSettings: Optional[
      zio.aws.chimesdkmeetings.model.EngineTranscribeMedicalSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.engineTranscribeMedicalSettings())
      .map(value =>
        zio.aws.chimesdkmeetings.model.EngineTranscribeMedicalSettings
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.TranscriptionConfiguration
  ): zio.aws.chimesdkmeetings.model.TranscriptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
