package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmeetings.model.primitives.{
  MediaRegion,
  PrimaryMeetingId,
  ClientRequestToken,
  ExternalMeetingId,
  ExternalUserId,
  TenantId
}
import scala.jdk.CollectionConverters._
final case class CreateMeetingWithAttendeesRequest(
    clientRequestToken: ClientRequestToken,
    mediaRegion: MediaRegion,
    meetingHostId: Optional[ExternalUserId] = Optional.Absent,
    externalMeetingId: ExternalMeetingId,
    meetingFeatures: Optional[
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration
    ] = Optional.Absent,
    notificationsConfiguration: Optional[
      zio.aws.chimesdkmeetings.model.NotificationsConfiguration
    ] = Optional.Absent,
    attendees: Iterable[
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem
    ],
    primaryMeetingId: Optional[PrimaryMeetingId] = Optional.Absent,
    tenantIds: Optional[Iterable[TenantId]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.chimesdkmeetings.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest = {
    import CreateMeetingWithAttendeesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest
      .builder()
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .mediaRegion(MediaRegion.unwrap(mediaRegion): java.lang.String)
      .optionallyWith(
        meetingHostId.map(value =>
          ExternalUserId.unwrap(value): java.lang.String
        )
      )(_.meetingHostId)
      .externalMeetingId(
        ExternalMeetingId.unwrap(externalMeetingId): java.lang.String
      )
      .optionallyWith(meetingFeatures.map(value => value.buildAwsValue()))(
        _.meetingFeatures
      )
      .optionallyWith(
        notificationsConfiguration.map(value => value.buildAwsValue())
      )(_.notificationsConfiguration)
      .attendees(attendees.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        primaryMeetingId.map(value =>
          PrimaryMeetingId.unwrap(value): java.lang.String
        )
      )(_.primaryMeetingId)
      .optionallyWith(
        tenantIds.map(value =>
          value.map { item =>
            TenantId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tenantIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest
      .wrap(buildAwsValue())
}
object CreateMeetingWithAttendeesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest =
      zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest(
        clientRequestToken,
        mediaRegion,
        meetingHostId.map(value => value),
        externalMeetingId,
        meetingFeatures.map(value => value.asEditable),
        notificationsConfiguration.map(value => value.asEditable),
        attendees.map { item =>
          item.asEditable
        },
        primaryMeetingId.map(value => value),
        tenantIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientRequestToken: ClientRequestToken
    def mediaRegion: MediaRegion
    def meetingHostId: Optional[ExternalUserId]
    def externalMeetingId: ExternalMeetingId
    def meetingFeatures: Optional[
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly
    ]
    def notificationsConfiguration: Optional[
      zio.aws.chimesdkmeetings.model.NotificationsConfiguration.ReadOnly
    ]
    def attendees: List[
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.ReadOnly
    ]
    def primaryMeetingId: Optional[PrimaryMeetingId]
    def tenantIds: Optional[List[TenantId]]
    def tags: Optional[List[zio.aws.chimesdkmeetings.model.Tag.ReadOnly]]
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getMediaRegion: ZIO[Any, Nothing, MediaRegion] =
      ZIO.succeed(mediaRegion)
    def getMeetingHostId: ZIO[Any, AwsError, ExternalUserId] =
      AwsError.unwrapOptionField("meetingHostId", meetingHostId)
    def getExternalMeetingId: ZIO[Any, Nothing, ExternalMeetingId] =
      ZIO.succeed(externalMeetingId)
    def getMeetingFeatures: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("meetingFeatures", meetingFeatures)
    def getNotificationsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.NotificationsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "notificationsConfiguration",
      notificationsConfiguration
    )
    def getAttendees: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.ReadOnly
    ]] = ZIO.succeed(attendees)
    def getPrimaryMeetingId: ZIO[Any, AwsError, PrimaryMeetingId] =
      AwsError.unwrapOptionField("primaryMeetingId", primaryMeetingId)
    def getTenantIds: ZIO[Any, AwsError, List[TenantId]] =
      AwsError.unwrapOptionField("tenantIds", tenantIds)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmeetings.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest
  ) extends zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest.ReadOnly {
    override val clientRequestToken: ClientRequestToken =
      zio.aws.chimesdkmeetings.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val mediaRegion: MediaRegion =
      zio.aws.chimesdkmeetings.model.primitives.MediaRegion(impl.mediaRegion())
    override val meetingHostId: Optional[ExternalUserId] = zio.aws.core.internal
      .optionalFromNullable(impl.meetingHostId())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives.ExternalUserId(value)
      )
    override val externalMeetingId: ExternalMeetingId =
      zio.aws.chimesdkmeetings.model.primitives
        .ExternalMeetingId(impl.externalMeetingId())
    override val meetingFeatures: Optional[
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.meetingFeatures())
      .map(value =>
        zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.wrap(value)
      )
    override val notificationsConfiguration: Optional[
      zio.aws.chimesdkmeetings.model.NotificationsConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationsConfiguration())
      .map(value =>
        zio.aws.chimesdkmeetings.model.NotificationsConfiguration.wrap(value)
      )
    override val attendees: List[
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.ReadOnly
    ] = impl
      .attendees()
      .asScala
      .map { item =>
        zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.wrap(item)
      }
      .toList
    override val primaryMeetingId: Optional[PrimaryMeetingId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.primaryMeetingId())
        .map(value =>
          zio.aws.chimesdkmeetings.model.primitives.PrimaryMeetingId(value)
        )
    override val tenantIds: Optional[List[TenantId]] = zio.aws.core.internal
      .optionalFromNullable(impl.tenantIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmeetings.model.primitives.TenantId(item)
        }.toList
      )
    override val tags
        : Optional[List[zio.aws.chimesdkmeetings.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmeetings.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest
  ): zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest.ReadOnly =
    new Wrapper(impl)
}
