package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmeetings.model.primitives.ExternalUserId
import scala.jdk.CollectionConverters._
final case class CreateAttendeeRequestItem(
    externalUserId: ExternalUserId,
    capabilities: Optional[
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequestItem = {
    import CreateAttendeeRequestItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequestItem
      .builder()
      .externalUserId(ExternalUserId.unwrap(externalUserId): java.lang.String)
      .optionallyWith(capabilities.map(value => value.buildAwsValue()))(
        _.capabilities
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.ReadOnly =
    zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem
      .wrap(buildAwsValue())
}
object CreateAttendeeRequestItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequestItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem =
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem(
        externalUserId,
        capabilities.map(value => value.asEditable)
      )
    def externalUserId: ExternalUserId
    def capabilities
        : Optional[zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly]
    def getExternalUserId: ZIO[Any, Nothing, ExternalUserId] =
      ZIO.succeed(externalUserId)
    def getCapabilities: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly
    ] = AwsError.unwrapOptionField("capabilities", capabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequestItem
  ) extends zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.ReadOnly {
    override val externalUserId: ExternalUserId =
      zio.aws.chimesdkmeetings.model.primitives
        .ExternalUserId(impl.externalUserId())
    override val capabilities: Optional[
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capabilities())
      .map(value =>
        zio.aws.chimesdkmeetings.model.AttendeeCapabilities.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequestItem
  ): zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.ReadOnly =
    new Wrapper(impl)
}
