package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAttendeeCapabilitiesResponse(
    attendee: Optional[zio.aws.chimesdkmeetings.model.Attendee] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse = {
    import UpdateAttendeeCapabilitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse
      .builder()
      .optionallyWith(attendee.map(value => value.buildAwsValue()))(_.attendee)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse.ReadOnly =
    zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse
      .wrap(buildAwsValue())
}
object UpdateAttendeeCapabilitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse =
      zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse(
        attendee.map(value => value.asEditable)
      )
    def attendee: Optional[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly]
    def getAttendee
        : ZIO[Any, AwsError, zio.aws.chimesdkmeetings.model.Attendee.ReadOnly] =
      AwsError.unwrapOptionField("attendee", attendee)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse
  ) extends zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse.ReadOnly {
    override val attendee
        : Optional[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attendee())
        .map(value => zio.aws.chimesdkmeetings.model.Attendee.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse
  ): zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse.ReadOnly =
    new Wrapper(impl)
}
