package zio.aws.chimesdkmeetings
import zio.aws.chimesdkmeetings.model.UntagResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.chimesdkmeetings.ChimeSdkMeetingsAsyncClient
import zio.aws.chimesdkmeetings.model.{
  CreateMeetingRequest,
  CreateMeetingWithAttendeesRequest,
  StopMeetingTranscriptionRequest,
  GetMeetingRequest,
  ListAttendeesRequest,
  ListTagsForResourceRequest,
  DeleteAttendeeRequest,
  GetAttendeeRequest,
  CreateAttendeeRequest,
  UpdateAttendeeCapabilitiesRequest,
  UntagResourceRequest,
  BatchCreateAttendeeRequest,
  StartMeetingTranscriptionRequest,
  DeleteMeetingRequest,
  TagResourceRequest,
  BatchUpdateAttendeeCapabilitiesExceptRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ChimeSdkMeetingsMock extends Mock[ChimeSdkMeetings] {
  object ListAttendees
      extends Stream[
        ListAttendeesRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.Attendee.ReadOnly
      ]
  object ListAttendeesPaginated
      extends Effect[
        ListAttendeesRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.ListAttendeesResponse.ReadOnly
      ]
  object GetMeeting
      extends Effect[
        GetMeetingRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.GetMeetingResponse.ReadOnly
      ]
  object BatchCreateAttendee
      extends Effect[
        BatchCreateAttendeeRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.ReadOnly
      ]
  object BatchUpdateAttendeeCapabilitiesExcept
      extends Effect[
        BatchUpdateAttendeeCapabilitiesExceptRequest,
        AwsError,
        Unit
      ]
  object UpdateAttendeeCapabilities
      extends Effect[
        UpdateAttendeeCapabilitiesRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse.ReadOnly
      ]
  object DeleteMeeting extends Effect[DeleteMeetingRequest, AwsError, Unit]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, ReadOnly]
  object DeleteAttendee extends Effect[DeleteAttendeeRequest, AwsError, Unit]
  object GetAttendee
      extends Effect[
        GetAttendeeRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.GetAttendeeResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.ListTagsForResourceResponse.ReadOnly
      ]
  object CreateMeeting
      extends Effect[
        CreateMeetingRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.CreateMeetingResponse.ReadOnly
      ]
  object StartMeetingTranscription
      extends Effect[StartMeetingTranscriptionRequest, AwsError, Unit]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.TagResourceResponse.ReadOnly
      ]
  object CreateMeetingWithAttendees
      extends Effect[
        CreateMeetingWithAttendeesRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse.ReadOnly
      ]
  object StopMeetingTranscription
      extends Effect[StopMeetingTranscriptionRequest, AwsError, Unit]
  object CreateAttendee
      extends Effect[
        CreateAttendeeRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.CreateAttendeeResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ChimeSdkMeetings] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ChimeSdkMeetings] { rts =>
        zio.ZIO.succeed {
          new ChimeSdkMeetings {
            val api: ChimeSdkMeetingsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ChimeSdkMeetings = this
            def listAttendees(request: ListAttendeesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkmeetings.model.Attendee.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAttendees, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAttendeesPaginated(request: ListAttendeesRequest): IO[
              AwsError,
              zio.aws.chimesdkmeetings.model.ListAttendeesResponse.ReadOnly
            ] = proxy(ListAttendeesPaginated, request)
            def getMeeting(request: GetMeetingRequest): IO[
              AwsError,
              zio.aws.chimesdkmeetings.model.GetMeetingResponse.ReadOnly
            ] = proxy(GetMeeting, request)
            def batchCreateAttendee(request: BatchCreateAttendeeRequest): IO[
              AwsError,
              zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.ReadOnly
            ] = proxy(BatchCreateAttendee, request)
            def batchUpdateAttendeeCapabilitiesExcept(
                request: BatchUpdateAttendeeCapabilitiesExceptRequest
            ): IO[AwsError, Unit] =
              proxy(BatchUpdateAttendeeCapabilitiesExcept, request)
            def updateAttendeeCapabilities(
                request: UpdateAttendeeCapabilitiesRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse.ReadOnly
            ] = proxy(UpdateAttendeeCapabilities, request)
            def deleteMeeting(
                request: DeleteMeetingRequest
            ): IO[AwsError, Unit] = proxy(DeleteMeeting, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, ReadOnly] = proxy(UntagResource, request)
            def deleteAttendee(
                request: DeleteAttendeeRequest
            ): IO[AwsError, Unit] = proxy(DeleteAttendee, request)
            def getAttendee(request: GetAttendeeRequest): IO[
              AwsError,
              zio.aws.chimesdkmeetings.model.GetAttendeeResponse.ReadOnly
            ] = proxy(GetAttendee, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.chimesdkmeetings.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def createMeeting(request: CreateMeetingRequest): IO[
              AwsError,
              zio.aws.chimesdkmeetings.model.CreateMeetingResponse.ReadOnly
            ] = proxy(CreateMeeting, request)
            def startMeetingTranscription(
                request: StartMeetingTranscriptionRequest
            ): IO[AwsError, Unit] = proxy(StartMeetingTranscription, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.chimesdkmeetings.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def createMeetingWithAttendees(
                request: CreateMeetingWithAttendeesRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse.ReadOnly
            ] = proxy(CreateMeetingWithAttendees, request)
            def stopMeetingTranscription(
                request: StopMeetingTranscriptionRequest
            ): IO[AwsError, Unit] = proxy(StopMeetingTranscription, request)
            def createAttendee(request: CreateAttendeeRequest): IO[
              AwsError,
              zio.aws.chimesdkmeetings.model.CreateAttendeeResponse.ReadOnly
            ] = proxy(CreateAttendee, request)
          }
        }
      }
    }
  }
}
