package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmeetings.model.primitives.GuidString
import scala.jdk.CollectionConverters._
final case class GetAttendeeRequest(
    meetingId: GuidString,
    attendeeId: GuidString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.GetAttendeeRequest = {
    import GetAttendeeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.GetAttendeeRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .attendeeId(GuidString.unwrap(attendeeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.GetAttendeeRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.GetAttendeeRequest.wrap(buildAwsValue())
}
object GetAttendeeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.GetAttendeeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.GetAttendeeRequest =
      zio.aws.chimesdkmeetings.model.GetAttendeeRequest(meetingId, attendeeId)
    def meetingId: GuidString
    def attendeeId: GuidString
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getAttendeeId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(attendeeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.GetAttendeeRequest
  ) extends zio.aws.chimesdkmeetings.model.GetAttendeeRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.meetingId())
    override val attendeeId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.attendeeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.GetAttendeeRequest
  ): zio.aws.chimesdkmeetings.model.GetAttendeeRequest.ReadOnly = new Wrapper(
    impl
  )
}
