package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EngineTranscribeMedicalSettings(
    languageCode: zio.aws.chimesdkmeetings.model.TranscribeMedicalLanguageCode,
    specialty: zio.aws.chimesdkmeetings.model.TranscribeMedicalSpecialty,
    `type`: zio.aws.chimesdkmeetings.model.TranscribeMedicalType,
    vocabularyName: Optional[String] = Optional.Absent,
    region: Optional[zio.aws.chimesdkmeetings.model.TranscribeMedicalRegion] =
      Optional.Absent,
    contentIdentificationType: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeMedicalContentIdentificationType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeMedicalSettings = {
    import EngineTranscribeMedicalSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeMedicalSettings
      .builder()
      .languageCode(languageCode.unwrap)
      .specialty(specialty.unwrap)
      .`type`(`type`.unwrap)
      .optionallyWith(vocabularyName.map(value => value: java.lang.String))(
        _.vocabularyName
      )
      .optionallyWith(region.map(value => value.unwrap))(_.region)
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.EngineTranscribeMedicalSettings.ReadOnly =
    zio.aws.chimesdkmeetings.model.EngineTranscribeMedicalSettings
      .wrap(buildAwsValue())
}
object EngineTranscribeMedicalSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeMedicalSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmeetings.model.EngineTranscribeMedicalSettings =
      zio.aws.chimesdkmeetings.model.EngineTranscribeMedicalSettings(
        languageCode,
        specialty,
        `type`,
        vocabularyName.map(value => value),
        region.map(value => value),
        contentIdentificationType.map(value => value)
      )
    def languageCode
        : zio.aws.chimesdkmeetings.model.TranscribeMedicalLanguageCode
    def specialty: zio.aws.chimesdkmeetings.model.TranscribeMedicalSpecialty
    def `type`: zio.aws.chimesdkmeetings.model.TranscribeMedicalType
    def vocabularyName: Optional[String]
    def region: Optional[zio.aws.chimesdkmeetings.model.TranscribeMedicalRegion]
    def contentIdentificationType: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeMedicalContentIdentificationType
    ]
    def getLanguageCode: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmeetings.model.TranscribeMedicalLanguageCode
    ] = ZIO.succeed(languageCode)
    def getSpecialty: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmeetings.model.TranscribeMedicalSpecialty
    ] = ZIO.succeed(specialty)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmeetings.model.TranscribeMedicalType
    ] = ZIO.succeed(`type`)
    def getVocabularyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getRegion: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribeMedicalRegion
    ] = AwsError.unwrapOptionField("region", region)
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribeMedicalContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeMedicalSettings
  ) extends zio.aws.chimesdkmeetings.model.EngineTranscribeMedicalSettings.ReadOnly {
    override val languageCode
        : zio.aws.chimesdkmeetings.model.TranscribeMedicalLanguageCode =
      zio.aws.chimesdkmeetings.model.TranscribeMedicalLanguageCode
        .wrap(impl.languageCode())
    override val specialty
        : zio.aws.chimesdkmeetings.model.TranscribeMedicalSpecialty =
      zio.aws.chimesdkmeetings.model.TranscribeMedicalSpecialty
        .wrap(impl.specialty())
    override val `type`: zio.aws.chimesdkmeetings.model.TranscribeMedicalType =
      zio.aws.chimesdkmeetings.model.TranscribeMedicalType.wrap(impl.`type`())
    override val vocabularyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyName())
      .map(value => value: String)
    override val region
        : Optional[zio.aws.chimesdkmeetings.model.TranscribeMedicalRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.region())
        .map(value =>
          zio.aws.chimesdkmeetings.model.TranscribeMedicalRegion.wrap(value)
        )
    override val contentIdentificationType: Optional[
      zio.aws.chimesdkmeetings.model.TranscribeMedicalContentIdentificationType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contentIdentificationType())
      .map(value =>
        zio.aws.chimesdkmeetings.model.TranscribeMedicalContentIdentificationType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeMedicalSettings
  ): zio.aws.chimesdkmeetings.model.EngineTranscribeMedicalSettings.ReadOnly =
    new Wrapper(impl)
}
