package zio.aws.chimesdkmeetings
import zio.aws.core.config.AwsConfig
import zio.aws.chimesdkmeetings.model.GetMeetingResponse.ReadOnly
import software.amazon.awssdk.services.chimesdkmeetings.{
  ChimeSdkMeetingsAsyncClientBuilder,
  ChimeSdkMeetingsAsyncClient
}
import software.amazon.awssdk.services.chimesdkmeetings.model.{
  BatchCreateAttendeeResponse,
  DeleteMeetingResponse,
  CreateMeetingRequest,
  CreateAttendeeResponse,
  CreateMeetingWithAttendeesRequest,
  GetAttendeeResponse,
  StopMeetingTranscriptionRequest,
  DeleteAttendeeResponse,
  GetMeetingRequest,
  ListAttendeesRequest,
  DeleteAttendeeRequest,
  CreateMeetingWithAttendeesResponse,
  UpdateAttendeeCapabilitiesResponse,
  GetAttendeeRequest,
  GetMeetingResponse,
  CreateAttendeeRequest,
  UpdateAttendeeCapabilitiesRequest,
  CreateMeetingResponse,
  StartMeetingTranscriptionResponse,
  BatchCreateAttendeeRequest,
  StartMeetingTranscriptionRequest,
  Attendee,
  ListAttendeesResponse,
  BatchUpdateAttendeeCapabilitiesExceptResponse,
  StopMeetingTranscriptionResponse,
  DeleteMeetingRequest,
  BatchUpdateAttendeeCapabilitiesExceptRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait ChimeSdkMeetings extends AspectSupport[ChimeSdkMeetings] {
  val api: ChimeSdkMeetingsAsyncClient
  def listAttendees(
      request: zio.aws.chimesdkmeetings.model.ListAttendeesRequest
  ): ZStream[Any, AwsError, zio.aws.chimesdkmeetings.model.Attendee.ReadOnly]
  def listAttendeesPaginated(
      request: zio.aws.chimesdkmeetings.model.ListAttendeesRequest
  ): IO[AwsError, zio.aws.chimesdkmeetings.model.ListAttendeesResponse.ReadOnly]
  def getMeeting(
      request: zio.aws.chimesdkmeetings.model.GetMeetingRequest
  ): IO[AwsError, ReadOnly]
  def batchCreateAttendee(
      request: zio.aws.chimesdkmeetings.model.BatchCreateAttendeeRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.ReadOnly
  ]
  def batchUpdateAttendeeCapabilitiesExcept(
      request: zio.aws.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest
  ): IO[AwsError, Unit]
  def updateAttendeeCapabilities(
      request: zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse.ReadOnly
  ]
  def deleteMeeting(
      request: zio.aws.chimesdkmeetings.model.DeleteMeetingRequest
  ): IO[AwsError, Unit]
  def deleteAttendee(
      request: zio.aws.chimesdkmeetings.model.DeleteAttendeeRequest
  ): IO[AwsError, Unit]
  def getAttendee(
      request: zio.aws.chimesdkmeetings.model.GetAttendeeRequest
  ): IO[AwsError, zio.aws.chimesdkmeetings.model.GetAttendeeResponse.ReadOnly]
  def createMeeting(
      request: zio.aws.chimesdkmeetings.model.CreateMeetingRequest
  ): IO[AwsError, zio.aws.chimesdkmeetings.model.CreateMeetingResponse.ReadOnly]
  def startMeetingTranscription(
      request: zio.aws.chimesdkmeetings.model.StartMeetingTranscriptionRequest
  ): IO[AwsError, Unit]
  def createMeetingWithAttendees(
      request: zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse.ReadOnly
  ]
  def stopMeetingTranscription(
      request: zio.aws.chimesdkmeetings.model.StopMeetingTranscriptionRequest
  ): IO[AwsError, Unit]
  def createAttendee(
      request: zio.aws.chimesdkmeetings.model.CreateAttendeeRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmeetings.model.CreateAttendeeResponse.ReadOnly
  ]
}
object ChimeSdkMeetings {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ChimeSdkMeetings] =
    customized(identity)
  def customized(
      customization: ChimeSdkMeetingsAsyncClientBuilder => ChimeSdkMeetingsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ChimeSdkMeetings] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ChimeSdkMeetingsAsyncClientBuilder => ChimeSdkMeetingsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ChimeSdkMeetings] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ChimeSdkMeetingsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      ChimeSdkMeetingsAsyncClient,
      ChimeSdkMeetingsAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      ChimeSdkMeetingsAsyncClient,
      ChimeSdkMeetingsAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ChimeSdkMeetingsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ChimeSdkMeetingsImpl[R](
      override val api: ChimeSdkMeetingsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ChimeSdkMeetings
      with AwsServiceBase[R] {
    override val serviceName: String = "ChimeSdkMeetings"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ChimeSdkMeetingsImpl[R1] = new ChimeSdkMeetingsImpl(api, newAspect, r)
    def listAttendees(
        request: zio.aws.chimesdkmeetings.model.ListAttendeesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.Attendee.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListAttendeesRequest,
      ListAttendeesResponse,
      Attendee
    ](
      "listAttendees",
      api.listAttendees,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.attendees().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chimesdkmeetings.model.Attendee.wrap(item))
      .provideEnvironment(r)
    def listAttendeesPaginated(
        request: zio.aws.chimesdkmeetings.model.ListAttendeesRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmeetings.model.ListAttendeesResponse.ReadOnly
    ] = asyncRequestResponse[ListAttendeesRequest, ListAttendeesResponse](
      "listAttendees",
      api.listAttendees
    )(request.buildAwsValue())
      .map(zio.aws.chimesdkmeetings.model.ListAttendeesResponse.wrap)
      .provideEnvironment(r)
    def getMeeting(
        request: zio.aws.chimesdkmeetings.model.GetMeetingRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[GetMeetingRequest, GetMeetingResponse](
        "getMeeting",
        api.getMeeting
      )(request.buildAwsValue())
        .map(zio.aws.chimesdkmeetings.model.GetMeetingResponse.wrap)
        .provideEnvironment(r)
    def batchCreateAttendee(
        request: zio.aws.chimesdkmeetings.model.BatchCreateAttendeeRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchCreateAttendeeRequest,
      BatchCreateAttendeeResponse
    ]("batchCreateAttendee", api.batchCreateAttendee)(request.buildAwsValue())
      .map(zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.wrap)
      .provideEnvironment(r)
    def batchUpdateAttendeeCapabilitiesExcept(
        request: zio.aws.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      BatchUpdateAttendeeCapabilitiesExceptRequest,
      BatchUpdateAttendeeCapabilitiesExceptResponse
    ](
      "batchUpdateAttendeeCapabilitiesExcept",
      api.batchUpdateAttendeeCapabilitiesExcept
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateAttendeeCapabilities(
        request: zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateAttendeeCapabilitiesRequest,
      UpdateAttendeeCapabilitiesResponse
    ]("updateAttendeeCapabilities", api.updateAttendeeCapabilities)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse.wrap
    ).provideEnvironment(r)
    def deleteMeeting(
        request: zio.aws.chimesdkmeetings.model.DeleteMeetingRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteMeetingRequest, DeleteMeetingResponse](
        "deleteMeeting",
        api.deleteMeeting
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteAttendee(
        request: zio.aws.chimesdkmeetings.model.DeleteAttendeeRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteAttendeeRequest, DeleteAttendeeResponse](
        "deleteAttendee",
        api.deleteAttendee
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getAttendee(
        request: zio.aws.chimesdkmeetings.model.GetAttendeeRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmeetings.model.GetAttendeeResponse.ReadOnly
    ] = asyncRequestResponse[GetAttendeeRequest, GetAttendeeResponse](
      "getAttendee",
      api.getAttendee
    )(request.buildAwsValue())
      .map(zio.aws.chimesdkmeetings.model.GetAttendeeResponse.wrap)
      .provideEnvironment(r)
    def createMeeting(
        request: zio.aws.chimesdkmeetings.model.CreateMeetingRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmeetings.model.CreateMeetingResponse.ReadOnly
    ] = asyncRequestResponse[CreateMeetingRequest, CreateMeetingResponse](
      "createMeeting",
      api.createMeeting
    )(request.buildAwsValue())
      .map(zio.aws.chimesdkmeetings.model.CreateMeetingResponse.wrap)
      .provideEnvironment(r)
    def startMeetingTranscription(
        request: zio.aws.chimesdkmeetings.model.StartMeetingTranscriptionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      StartMeetingTranscriptionRequest,
      StartMeetingTranscriptionResponse
    ]("startMeetingTranscription", api.startMeetingTranscription)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createMeetingWithAttendees(
        request: zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateMeetingWithAttendeesRequest,
      CreateMeetingWithAttendeesResponse
    ]("createMeetingWithAttendees", api.createMeetingWithAttendees)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse.wrap
    ).provideEnvironment(r)
    def stopMeetingTranscription(
        request: zio.aws.chimesdkmeetings.model.StopMeetingTranscriptionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      StopMeetingTranscriptionRequest,
      StopMeetingTranscriptionResponse
    ]("stopMeetingTranscription", api.stopMeetingTranscription)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createAttendee(
        request: zio.aws.chimesdkmeetings.model.CreateAttendeeRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmeetings.model.CreateAttendeeResponse.ReadOnly
    ] = asyncRequestResponse[CreateAttendeeRequest, CreateAttendeeResponse](
      "createAttendee",
      api.createAttendee
    )(request.buildAwsValue())
      .map(zio.aws.chimesdkmeetings.model.CreateAttendeeResponse.wrap)
      .provideEnvironment(r)
  }
  def listAttendees(
      request: zio.aws.chimesdkmeetings.model.ListAttendeesRequest
  ): ZStream[
    zio.aws.chimesdkmeetings.ChimeSdkMeetings,
    AwsError,
    zio.aws.chimesdkmeetings.model.Attendee.ReadOnly
  ] = ZStream.serviceWithStream(_.listAttendees(request))
  def listAttendeesPaginated(
      request: zio.aws.chimesdkmeetings.model.ListAttendeesRequest
  ): ZIO[
    zio.aws.chimesdkmeetings.ChimeSdkMeetings,
    AwsError,
    zio.aws.chimesdkmeetings.model.ListAttendeesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAttendeesPaginated(request))
  def getMeeting(
      request: zio.aws.chimesdkmeetings.model.GetMeetingRequest
  ): ZIO[zio.aws.chimesdkmeetings.ChimeSdkMeetings, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getMeeting(request))
  def batchCreateAttendee(
      request: zio.aws.chimesdkmeetings.model.BatchCreateAttendeeRequest
  ): ZIO[
    zio.aws.chimesdkmeetings.ChimeSdkMeetings,
    AwsError,
    zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchCreateAttendee(request))
  def batchUpdateAttendeeCapabilitiesExcept(
      request: zio.aws.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest
  ): ZIO[zio.aws.chimesdkmeetings.ChimeSdkMeetings, AwsError, Unit] =
    ZIO.serviceWithZIO(_.batchUpdateAttendeeCapabilitiesExcept(request))
  def updateAttendeeCapabilities(
      request: zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest
  ): ZIO[
    zio.aws.chimesdkmeetings.ChimeSdkMeetings,
    AwsError,
    zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAttendeeCapabilities(request))
  def deleteMeeting(
      request: zio.aws.chimesdkmeetings.model.DeleteMeetingRequest
  ): ZIO[zio.aws.chimesdkmeetings.ChimeSdkMeetings, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteMeeting(request))
  def deleteAttendee(
      request: zio.aws.chimesdkmeetings.model.DeleteAttendeeRequest
  ): ZIO[zio.aws.chimesdkmeetings.ChimeSdkMeetings, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAttendee(request))
  def getAttendee(
      request: zio.aws.chimesdkmeetings.model.GetAttendeeRequest
  ): ZIO[
    zio.aws.chimesdkmeetings.ChimeSdkMeetings,
    AwsError,
    zio.aws.chimesdkmeetings.model.GetAttendeeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAttendee(request))
  def createMeeting(
      request: zio.aws.chimesdkmeetings.model.CreateMeetingRequest
  ): ZIO[
    zio.aws.chimesdkmeetings.ChimeSdkMeetings,
    AwsError,
    zio.aws.chimesdkmeetings.model.CreateMeetingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMeeting(request))
  def startMeetingTranscription(
      request: zio.aws.chimesdkmeetings.model.StartMeetingTranscriptionRequest
  ): ZIO[zio.aws.chimesdkmeetings.ChimeSdkMeetings, AwsError, Unit] =
    ZIO.serviceWithZIO(_.startMeetingTranscription(request))
  def createMeetingWithAttendees(
      request: zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest
  ): ZIO[
    zio.aws.chimesdkmeetings.ChimeSdkMeetings,
    AwsError,
    zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMeetingWithAttendees(request))
  def stopMeetingTranscription(
      request: zio.aws.chimesdkmeetings.model.StopMeetingTranscriptionRequest
  ): ZIO[zio.aws.chimesdkmeetings.ChimeSdkMeetings, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopMeetingTranscription(request))
  def createAttendee(
      request: zio.aws.chimesdkmeetings.model.CreateAttendeeRequest
  ): ZIO[
    zio.aws.chimesdkmeetings.ChimeSdkMeetings,
    AwsError,
    zio.aws.chimesdkmeetings.model.CreateAttendeeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAttendee(request))
}
