package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchCreateAttendeeResponse(
    attendees: Optional[Iterable[zio.aws.chimesdkmeetings.model.Attendee]] =
      Optional.Absent,
    errors: Optional[
      Iterable[zio.aws.chimesdkmeetings.model.CreateAttendeeError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeResponse = {
    import BatchCreateAttendeeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeResponse
      .builder()
      .optionallyWith(
        attendees.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attendees)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.ReadOnly =
    zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse
      .wrap(buildAwsValue())
}
object BatchCreateAttendeeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse =
      zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse(
        attendees.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attendees
        : Optional[List[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly]]
    def errors: Optional[
      List[zio.aws.chimesdkmeetings.model.CreateAttendeeError.ReadOnly]
    ]
    def getAttendees: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmeetings.model.Attendee.ReadOnly
    ]] = AwsError.unwrapOptionField("attendees", attendees)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmeetings.model.CreateAttendeeError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeResponse
  ) extends zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.ReadOnly {
    override val attendees
        : Optional[List[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attendees())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmeetings.model.Attendee.wrap(item)
          }.toList
        )
    override val errors: Optional[
      List[zio.aws.chimesdkmeetings.model.CreateAttendeeError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmeetings.model.CreateAttendeeError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeResponse
  ): zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.ReadOnly =
    new Wrapper(impl)
}
